% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdd.R
\name{mdd}
\alias{mdd}
\title{Martingale Difference Divergence}
\usage{
mdd(X, Y, compute = "C", center = "U")
}
\arguments{
\item{X}{A vector, matrix or data frame, where rows represent samples, and columns represent variables.}

\item{Y}{A vector, matrix or data frame, where rows represent samples, and columns represent variables.}

\item{compute}{The method for computation, including
\itemize{
  \item \code{C}: computation implemented in C code;
  \item \code{R}: computation implemented in R code.
}}

\item{center}{The approach for centering, including
\itemize{
  \item \code{U}: U-centering which leads to an unbiased estimator;
  \item \code{D}: double-centering which leads to a biased estimator.
}}
}
\value{
\code{mdd} returns the value of squared martingale difference divergence.
}
\description{
\code{mdd} measures conditional mean dependence of \code{Y} given \code{X},
where each contains one variable (univariate) or more variables (multivariate).
}
\examples{
# X, Y are vectors with 10 samples and 1 variable
X <- rnorm(10)
Y <- rnorm(10)

mdd(X, Y, compute = "C")
mdd(X, Y, compute = "R")

# X, Y are 10 x 2 matrices with 10 samples and 2 variables
X <- matrix(rnorm(10 * 2), 10, 2)
Y <- matrix(rnorm(10 * 2), 10, 2)

mdd(X, Y, center = "U")
mdd(X, Y, center = "D")
}
\references{
Shao, X., and Zhang, J. (2014).
  Martingale difference correlation and its use in high-dimensional variable screening.
  Journal of the American Statistical Association, 109(507), 1302-1318.
  \url{http://dx.doi.org/10.1080/01621459.2014.887012}.

Park, T., Shao, X., and Yao, S. (2015).
  Partial martingale difference correlation.
  Electronic Journal of Statistics, 9(1), 1492-1517.
  \url{http://dx.doi.org/10.1214/15-EJS1047}.
}
