% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E4.Diagnostics.EDAplot.R
\name{E4.Diagnostics.EDAplot}
\alias{E4.Diagnostics.EDAplot}
\title{Diagnostics: Plot EDA data and button presses}
\usage{
E4.Diagnostics.EDAplot(participant_list, rdslocation.binnedEDA,
  rdslocation.buttonpress, plotlocation.EDA, RejectFlagCount = 48,
  Plot_E4s = TRUE, display_plot = FALSE)
}
\arguments{
\item{participant_list}{list of participant numbers NOTE: This should match the names of the folders (e.g., participant 1001's data should be in a folder called "1001").}

\item{rdslocation.binnedEDA}{folder location where binned EDA is stored (from E4.extras.BinEDA function).}

\item{rdslocation.buttonpress}{location of folder where button press output is stored (from part extract raw EDA part 2). Set to FALSE if you do not want to plot the button presses.}

\item{plotlocation.EDA}{Folder where you want to store the PDF plots. Set this to FALSE if you do not want to save the PDF output. You should only set to false if you are displaying the plot instead, and thus should also set display_plot to TRUE.}

\item{RejectFlagCount}{What percent of samples in the bin must be bad for the entire bin to be marked bad? Default is 48, which is 10 percent of samples in a 2-minute bin.}

\item{Plot_E4s}{Do you want a line at the bottom of the plot showing which E4 the participant was wearing?}

\item{display_plot}{Do you want the plot to be displayed on screen in addition to saving the PDF file? Defaults to false. This is most useful if you are only looking at one participant's data.}
}
\description{
This will allow you to see all binned EDA data for a participant, along with which band they were wearing and when they pressed the event marker. One PDF file is made per participant. You must run E4.extras.BinEDA() first to prepare for this step.
}
\examples{
E4.Diagnostics.EDAplot(participant_list=c(1001),
                       rdslocation.buttonpress=FALSE,
                       rdslocation.binnedEDA=paste(system.file(package="E4tools"),
                       "/extdata/plots/",sep=""),
                       plotlocation.EDA=FALSE,display_plot=TRUE)
}
\keyword{diagnostics}
\keyword{plots}
