% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{models_dia}
\alias{models_dia}
\title{Run Multiple Diagnostic Models}
\usage{
models_dia(
  data,
  model = "all_dia",
  tune = FALSE,
  seed = 123,
  threshold_choices = "default",
  positive_label_value = 1,
  negative_label_value = 0,
  new_positive_label = "Positive",
  new_negative_label = "Negative"
)
}
\arguments{
\item{data}{A data frame where the first column is the sample ID, the second
is the outcome label, and subsequent columns are features.}

\item{model}{A character string or vector of character strings, specifying
which models to run. Use "all_dia" to run all registered models.}

\item{tune}{Logical, whether to enable hyperparameter tuning for individual models.}

\item{seed}{An integer, for reproducibility of random processes.}

\item{threshold_choices}{A character string (e.g., "f1", "youden", "default")
or a numeric value (0-1), or a named list/vector allowing different threshold
strategies/values for each model.}

\item{positive_label_value}{A numeric or character value in the raw data
representing the positive class.}

\item{negative_label_value}{A numeric or character value in the raw data
representing the negative class.}

\item{new_positive_label}{A character string, the desired factor level name
for the positive class (e.g., "Positive").}

\item{new_negative_label}{A character string, the desired factor level name
for the negative class (e.g., "Negative").}
}
\value{
A named list, where each element corresponds to a run model and
contains its trained \code{model_object}, \code{sample_score} data frame, and
\code{evaluation_metrics}.
}
\description{
Trains and evaluates one or more registered diagnostic models on a given dataset.
}
\examples{
\donttest{
# This example assumes your package includes a dataset named 'train_dia'.
# If not, you should create a toy data frame similar to the one below.
#
# train_dia <- data.frame(
#   ID = paste0("Patient", 1:100),
#   Disease_Status = sample(c(0, 1), 100, replace = TRUE),
#   FeatureA = rnorm(100),
#   FeatureB = runif(100)
# )

# Ensure the 'train_dia' dataset is available in the environment
# For example, if it is exported by your package:
# data(train_dia)

# Check if 'train_dia' exists, otherwise skip the example
if (exists("train_dia")) {
  # 1. Initialize the modeling system
  initialize_modeling_system_dia()

  # 2. Run selected models
  results <- models_dia(
    data = train_dia,
    model = c("rf", "lasso"), # Run only Random Forest and Lasso
    threshold_choices = list(rf = "f1", lasso = 0.6), # Different thresholds
    positive_label_value = 1,
    negative_label_value = 0,
    new_positive_label = "Case",
    new_negative_label = "Control",
    seed = 42
  )

  # 3. Print summaries
  for (model_name in names(results)) {
    print_model_summary_dia(model_name, results[[model_name]])
  }
}
}
}
\seealso{
\code{\link{initialize_modeling_system_dia}}, \code{\link{evaluate_model_dia}}
}
