% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynCommPostProcessR.R
\name{DynCommPostProcessR}
\alias{DynCommPostProcessR}
\title{DynCommPostProcessR(postProcessing, previous, Parameters)}
\usage{
DynCommPostProcessR(postProcessing, previous, Parameters)
}
\arguments{
\item{Parameters}{A two column matrix defining additional parameters. See
the PARAMETERS section on this page}

\item{Algorithm}{One of the available ALGORITHM See \code{\link{ALGORITHM}}}

\item{Criterion}{One of the available CRITERION. See \code{\link{CRITERION}}}
}
\value{
\code{DynCommPostProcessR} object
}
\description{
Provides a single interface for all post processing algorithms implemented in R.
}
\details{
Includes methods to get results of processing and to interact with the 
vertices, edges and communities.
}
\section{PARAMETERS}{

A two column matrix defining additional parameters to be passed to the
selected ALGORITHM and CRITERION.
The first column names the parameter and the second defines its value.
\describe{
  \item{
  -c
  }{
  Owsinski-Zadrozny quality function parameter. Values [0.0:1.0]. Default: 0.5
  }
  \item{
  -k
  }{
  Shi-Malik quality function kappa_min value. Value > 0 . Default 1
  }
  \item{
  -w
  }{
  Treat graph as weighted. In other words, do not ignore weights for edges 
  that define them when inserting edges in the graph.
  A weight of exactly zero removes the edge instead of inserting so its
  weight is never ignored.
  Without this parameter defined or for edges that do not have a weight defined, 
  edges are assigned the default value of 1 (one).
  As an example, reading from a file may define weights (a third column) for
  some edges (defined in rows, one per row) and not for others. With this
  parameter defined, the edges that have weights that are not exactly zero,
  have their weight replaced by the default value.
  }
  \item{
  -e
  }{
  Stops when, on a cycle of the algorithm, the quality is increased by less 
  than the value given in this parameter.
  }
  \item{
  cv
  }{
  Community-Vertex.
  Boolean parameter that indicates if sending community mapping to a file
  prints the community first, if true, or the vertex first, if false. See
  \code{\link{communityMapping}} for details.
  Default TRUE
  }
}
}

\section{Methods}{

\describe{


  \item{results(differential)}{Get additional results of the algorithm or the currently selected post processing steps. See \code{\link{results}}}
  

  \item{quality()}{Get the quality measurement of the graph after the last iteration. See \code{\link{quality}}}
  

  \item{communityCount()}{Get the number of communities after the last iteration. See \code{\link{communityCount}}}
  

  \item{communities()}{Get all communities after the last iteration. See \code{\link{communities}}}
  

  \item{communitiesEdgeCount()}{Get the number of community to community edges in the graph. See \code{\link{communitiesEdgeCount}}}
  

  \item{communityNeighbours(community)}{Get the neighbours of the given community after the last iteration. See \code{\link{communityNeighbours}}}
  

  \item{communityInnerEdgesWeight(community)}{Get the sum of weights of the inner edges of the given community after the last iteration. See \code{\link{communityInnerEdgesWeight}}}
  

  \item{communityTotalWeight(community)}{Get the sum of weights of all edges of the given community after the last iteration. See \code{\link{communityTotalWeight}}}
  

  \item{communityEdgeWeight(source,destination)}{Get the weight of the edge that goes from source to destination after the last iteration. See \code{\link{communityEdgeWeight}}}
  

  \item{communityVertexCount(community)}{Get the amount of vertices in the given community after the last iteration. See \code{\link{communityVertexCount}}}
  

  \item{community(vertex)}{Get the community of the given vertex after the last iteration. See \code{\link{community}}}
  

  \item{vertexCount()}{Get the total number of vertices after the last iteration. See \code{\link{vertexCount}}}
  

  \item{verticesAll()}{Get all vertices in the graph after the last iteration. See \code{\link{verticesAll}}}
  

  \item{neighbours(vertex)}{Get the neighbours of the given vertex after the last iteration. See \code{\link{neighbours}}}
  

  \item{edgeWeight(source,destination)}{Get the weight of the edge that goes from source vertex to destination vertex after the last iteration. See \code{\link{edgeWeight}}}
  

  \item{vertices(community)}{Get all vertices belonging to the given community after the last iteration. See \code{\link{vertices}}}
  

  \item{edgeCount()}{Get the number of vertex to vertex edges in the graph. See \code{\link{edgeCount}}}
  

  \item{communityMapping()}{Get the community mapping for all communities after the last iteration.See \code{\link{communityMapping}}}
  

  \item{communityMapping()}{Get the community mapping for all communities after the last iteration.See \code{\link{communityMapping}}}
  

}
}

\examples{
\dontrun{
Parameters<-matrix(c("-e","0.1"),1,2,TRUE)
dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
dc$addRemoveEdgesFile("initial_graph.txt")
dc$communityCount()
dc$communities()
dc$communityNodeCount(1)
dc$vertices(1)
dc$communityMapping(TRUE)
dc$time()
dc$addRemoveEdgesFile("s0000000000.txt")
}

}
\seealso{
\code{\link{DynComm}}
}
\author{
poltergeist0
}
\keyword{internal}
