% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BS_call.R, R/get_underlying.R
\name{BS_call}
\alias{BS_call}
\alias{get_underlying}
\title{European Call Option Price and the Inverse}
\usage{
BS_call(V, D, T., r, vol)

get_underlying(S, D, T., r, vol, tol = 1e-12)
}
\arguments{
\item{V}{numeric vector or scalar with price of the underlying asset.}

\item{D}{numeric vector or scalar with debt due in \code{T.}.}

\item{T.}{numeric vector or scalar with time to maturity.}

\item{r}{numeric vector or scalar with risk free rates.}

\item{vol}{numeric vector or scalar with volatilities, \eqn{\sigma}s.}

\item{S}{numeric vector with observed stock prices.}

\item{tol}{numeric scalar with tolerance to \code{\link{get_underlying}}.
The difference is scaled  if the absolute of \code{S} is large than \code{tol}
as in the \code{tolerance} argument to \code{\link{all.equal.numeric}}.}
}
\value{
Numeric vector or scalar with price of the underlying asset or equity price.
}
\description{
Computes the European call option and the inverse. All vectors
with length greater than one needs to have the same length.
}
\examples{
library(DtD)
set.seed(58661382)
sims <- BS_sim(
  vol = .2, mu = .03, dt = .1, V_0 = 100, T. = 1, D = rep(80, 20), r = .01)

stopifnot(with(
  sims, isTRUE(all.equal(V, get_underlying(S, D, T, r, vol)))))
stopifnot(with(
  sims, isTRUE(all.equal(S, BS_call(V, D, T, r, vol)))))

}
\seealso{
\code{\link{BS_fit}}
}
