% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estObserved.R
\name{estObserved}
\alias{estObserved}
\title{Estimate observed data density}
\usage{
estObserved(resDecision, resND)
}
\arguments{
\item{resDecision}{output of \code{\link{estDstarM}}.}

\item{resND}{output of \code{\link{estND}}.}
}
\value{
a list (S3 object of class 'DstarM') that contains:

\item{obsNorm}{A matrix containing normalized densities of each condition response pair.}
\item{obs}{A matrix containing unnormalized densities of each condition response pair.}
\item{tt}{The time grid used.}
\item{fit}{A list containing the values of the objective function for the total model ($total),
for the decision model ($Decision) and for the nondecision distribution(s) ($ND).}
\item{npar}{The number of parameters used in the decision model.}
\item{obsIdx}{A numeric vector containing indices of any not observed condition-response pairs.}
}
\description{
Estimates the density of the observed data by convoluting the estimated decision distributions
with the estimated nondecision distributions. If a traditional analysis was run the argument resND can
be omitted.
}
\examples{
# simulate data with three stimuli of different difficulty.
# this implies different drift rates across conditions.
# define a time grid. A more reasonable stepsize is .01; this is just for speed.
tt = seq(0, 5, .1)
pars = c(.8, 2, .5, .5, .5, # condition 1
        .8, 3, .5, .5, .5, # condition 2
        .8, 4, .5, .5, .5) # condition 3
pdfND = dbeta(tt, 10, 30)
# simulate data
lst = simData(n = 3e5, pars = pars, tt = tt, pdfND = pdfND, return.pdf = TRUE)
dat = lst$dat
# define restriction matrix
restr = matrix(1:5, 5, 3)
restr[2, 2:3] = 6:7 # allow drift rates to differ
# fix variance parameters
fixed = matrix(c('sz1', .5, 'sv1', .5), 2, 2)
\dontrun{
# Run D*M analysis
resD = estDstarM(dat = dat, tt = tt, restr = restr, fixed = fixed)
# Estimate nondecision density
resND = estND(resD)
# Estimate observed density
resObs = estObserved(resD, resND)
# plot histograms with overlayed
# densities per condition-response pair
plotObserved(resObserved = resObs, data = dat,
            xlim = c(0, 1))
# plot estimated and true densities
plot(resObs, col = rep(1:3, each = 2), xlim = 0:1)
matlines(tt, lst$pdfNormalized, col = rep(1:3, each = 2), lty = 2)
}
}

