% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableDrugUtilisation}
\alias{tableDrugUtilisation}
\title{Format a drug_utilisation object into a visual table.}
\usage{
tableDrugUtilisation(
  result,
  header = c("cdm_name"),
  groupColumn = c("cohort_name", strataColumns(result)),
  type = "gt",
  hide = c("variable_level", "censor_date", "cohort_table_name", "gap_era", "index_date",
    "restrict_incident"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default
values.}
}
\value{
A table with a formatted version of summariseIndication() results.
}
\description{
Format a drug_utilisation object into a visual table.
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()
codelist <- getDrugIngredientCodes(cdm = cdm, name = "acetaminophen")
cdm <- generateDrugUtilisationCohortSet(cdm = cdm,
                                        name = "dus_cohort",
                                        conceptSet = codelist)

drugUse <- cdm$dus_cohort |>
  summariseDrugUtilisation(ingredientConceptId = 1125315)

tableDrugUtilisation(drugUse)
}

}
