% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug.identification.R
\name{drug.ident}
\alias{drug.ident}
\title{Dr. Insight Drug Identification}
\usage{
drug.ident(
  query.data = NULL,
  cmap.ref.profiles = NULL,
  repurposing.unit = "treatment",
  CEG.threshold = 0.05,
  connectivity = "negative"
)
}
\arguments{
\item{query.data}{User provided differential expression analysis results(e.g. t-test statistic scores) of querying data (either disease phenotype data, or drug expression data). The column names for gene symboles and statistic scores must be "geneSymbol" and "score".}

\item{cmap.ref.profiles}{Dr. Insight provided CMap drug rank matrix containing all 6100 instances of CMap data set.The example of reference data can be loaded with data("example.profiles"). The real cmap data can be loaded with the function 'get.cmap.ref' (See instructions in vignette).}

\item{repurposing.unit}{The parameter of either "treatment" or "drug", which indicates if user want the algorithm to test drug repurposing p value at treatment level or drug level. The default is "treatment", which treats the drug data from different cell lines separately.}

\item{CEG.threshold}{The p value threshold to select the consistently differential expressed genes (CEGs).}

\item{connectivity}{The type of connectivity, either "negative" or "positive". Negative connectivity is used when the query data is the differential scores from disease data, and Dr. Insight will repurpose drugs that can potentially reverse the query disease phenotype. Positive connectivity is used when the query data is from a drug profile, and Dr. Insight will return the drugs that are similar to the query drug.}
}
\description{
This function allows user to use the differential expression data of their interested disease phenotype or drug profile to query against CMap reference drug expression profiles.
This function returns an obejct of three elements: a table of drug p-values reflecting the connectivity between query data and CMap drugs; a table contains all the meta information of CMap drugs; and an object of p-values of identified CEGs for each drug instance.
}
\examples{

## load in the example query disease data
data("example.disease")
data("example.drug.profiles")

## get the Dr. Insight drug identification results
drug.ident.res = drug.ident(query.data = example.disease, cmap.ref.profiles = example.drug.profiles,
                 repurposing.unit = "treatment", connectivity = "negative")

drug.pvals = drug.ident.res$drug.pvals
}
\keyword{Drug}
\keyword{Indetification}
