% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GumbelCopulaVaR.R
\name{GumbelCopulaVaR}
\alias{GumbelCopulaVaR}
\title{Bivariate Gumbel Copule VaR}
\usage{
GumbelCopulaVaR(mu1, mu2, sigma1, sigma2, beta, cl)
}
\arguments{
\item{mu1}{Mean of Profit/Loss on first position}

\item{mu2}{Mean of Profit/Loss on second position}

\item{sigma1}{Standard Deviation of Profit/Loss on first position}

\item{sigma2}{Standard Deviation of Profit/Loss on second position}

\item{beta}{Gumber copula parameter (greater than 1)}

\item{cl}{VaR onfidece level}
}
\value{
Copula based VaR
}
\description{
Derives VaR using bivariate Gumbel or logistic copula with specified inputs
for normal marginals.
}
\examples{
# VaR using bivariate Gumbel for X and Y with given parameters:
   GumbelCopulaVaR(1.1, 3.1, 1.2, 1.5, 1.1, .95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Dowd, K. and Fackler, P. Estimating VaR with copulas. Financial Engineering
News, 2004.
}

