% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinProb4Mixtures.R
\name{BinProb4Mixtures}
\alias{BinProb4Mixtures}
\title{Bin Probabilities}
\usage{
BinProb4Mixtures(Means, SDs, Weights, Breaks, IsLogDistribution = rep(F,
  length(Means)), LimitsAreFinite = T)
}
\arguments{
\item{Means}{Means of the GMM Components}

\item{SDs}{Standard Deviations of the GMM Components}

\item{Weights}{Weights of the GMM Components}

\item{Breaks}{Breaks Defining c-1 or c+1 bins (depending on LimitsAreFinite)}

\item{IsLogDistribution}{If True, the GMM is interpreted as a logarithmic}

\item{LimitsAreFinite}{If True, there are c+1 Bins, where the first and last bin are of inifinite size}
}
\value{
Probabalities of either c-1 or c+1 bins/intervals (depending on LimitsAreFinite)
}
\description{
Calculates the probability of bins/intervals within the dataspace defined by given breaks between them.
}
\examples{
 
Data = c(rnorm(50,1,2), rnorm(50,3,4))
NoBins = AdaptGauss::OptimalNoBins(Data)
breaks = seq(min(Data),max(Data), length.out=length(NoBins)+1)
BinProb4Mixtures(c(1,3), c(2,4), c(0.5,0.5), breaks)
}
\author{
Florian Lerch
}
