% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_df_covar_line.R
\docType{methods}
\name{add_df_covar_line}
\alias{add_df_covar_line}
\title{Add covariate levels detection function plots}
\arguments{
\item{ddf}{a fitted detection function object.}

\item{data}{a \code{data.frame} with the covariate combination you want to plot.}

\item{\dots}{extra arguments to give to \code{\link[graphics:lines]{lines}} (e.g.,
\code{lty}, \code{lwd}, \code{col}).}

\item{ndist}{number of distances at which to evaluate the detection function.}

\item{pdf}{should the line be drawn on the probability density scale;
ignored for line transects}

\item{breaks}{required to ensure that PDF lines are the right size, should
match what is supplied to original \code{plot} command. Defaults to
"Sturges" breaks, as in \code{\link[graphics:hist]{hist}}. Only used if \code{pdf=TRUE}}
}
\value{
invisibly, the values of detectability over the truncation range.
}
\description{
Add a line or lines to a plot of the detection function which correspond to
a a given covariate combination. These can be particularly useful when there
is a small number of factor levels or if quantiles of a continuous covariate
are specified.
}
\details{
All covariates must be specified in \code{data}. Plots can become quite busy
when this approach is used. It may be useful to fix some covariates at their
median level and plot set values of a covariate of interest. For example
setting weather (e.g., Beaufort) to its median and plotting levels of
observer, then creating a second plot for a fixed observer with levels of
weather.

Arguments to \code{\link{lines}} are supplied in \dots and aesthetics like
line type (\code{lty}), line width (\code{lwd}) and colour (\code{col}) are
recycled. By default \code{lty} is used to distinguish between the lines. It
may be useful to add a \code{\link{legend}} to the plot (lines are plotted
in the order of \code{data}).
}
\note{
This function is located in the \code{mrds} package but the
documentation is provided here for easy access.
}
\examples{
\dontrun{
# example using a model for the minke data
data(minke)
# fit a model
result <- ds(minke, formula=~Region.Label)

# make a base plot, showpoints=FALSE makes the plot less busy
plot(result, showpoints=FALSE)

# add lines for sex one at a time
add_df_covar_line(result, data.frame(Region.Label="South"), lty=2)
add_df_covar_line(result, data.frame(Region.Label="North"), lty=3)

# add a legend
legend(1.5, 1, c("Average", "South", "North"), lty=1:3)

# point transect example
data(amakihi)
result <- ds(amakihi, truncation=150, transect="point", formula=~OBs)
plot(result, showpoints=FALSE, pdf=TRUE)
add_df_covar_line(result,
                  data.frame(OBs=na.omit(unique(amakihi$OBs))), pdf=TRUE)
}
}
\author{
David L Miller
}
