% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.dsmodel.R
\name{AIC.dsmodel}
\alias{AIC.dsmodel}
\title{Akaike's An Information Criterion for detection functions}
\usage{
\method{AIC}{dsmodel}(object, ..., k = 2)
}
\arguments{
\item{object}{a fitted detection function object}

\item{\dots}{optionally more fitted model objects.}

\item{k}{penalty per parameter to be used; the default \code{k = 2} is the
"classical" AIC}
}
\description{
Extract the AIC from a fitted detection function.
}
\examples{
\dontrun{
library(Distance)
data(minke)
model <- ds(minke, truncation=4)
model_hr <- ds(minke, truncation=4, key="hr")
# extract the AIC for 2 models
AIC(model, model_hr)
}
}
\author{
David L Miller
}
