% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{plot.DiscreteFDR}
\alias{plot.DiscreteFDR}
\title{Plot Method for \code{DiscreteFDR} objects}
\usage{
\method{plot}{DiscreteFDR}(
  x,
  col = c(2, 4, 1),
  pch = c(1, 1, 1),
  lwd = c(1, 1, 1),
  type.crit = "b",
  legend = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class "\code{DiscreteFDR}".}

\item{col}{a numeric or character vector of length 3 indicating the
colors of the \enumerate{
\item rejected p-values
\item accepted p-values
\item critical values (if present).
}}

\item{pch}{a numeric or character vector of length 3 indicating the
point characters of the \enumerate{
\item rejected p-values
\item accepted p-values
\item critical values (if present and \code{type.crit}
is a plot type like \code{'p'}, \code{'b'} etc.).
}}

\item{lwd}{a numeric vector of length 3 indicating the thickness of
the points and lines.}

\item{type.crit}{1-character string giving the type of plot desired for the
critical values (e.g.: \code{'p'}, \code{'l'} etc; see \link{plot}).}

\item{legend}{if NULL, no legend is plotted; otherwise expecting a
character string like "topleft" etc. or a numeric vector
of two elements indicating (x, y) coordinates.}

\item{...}{further arguments to \link{plot.default}.}
}
\description{
Plots raw p-values of a \code{DiscreteFDR} object and highlights rejected and
accepted p-values. If present, the critical values are plotted, too.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

#Construction of the p-values and their support
df.formatted <- fisher.pvalues.support(counts = df, input = "noassoc")
raw.pvalues <- df.formatted$raw
pCDFlist <- df.formatted$support

DBH.su.fast <- DBH(raw.pvalues, pCDFlist)
DBH.su.crit <- DBH(raw.pvalues, pCDFlist, ret.crit.consts = TRUE)
DBH.sd.fast <- DBH(raw.pvalues, pCDFlist, direction = "sd")
DBH.sd.crit <- DBH(raw.pvalues, pCDFlist, direction = "sd", ret.crit.consts = TRUE)

plot(DBH.sd.fast)
plot(DBH.sd.crit, xlim = c(1, 5), ylim = c(0, 0.4))
plot(DBH.su.fast, col = c(2, 4), pch = c(2, 3), lwd = c(2, 2), 
    legend = "topleft", xlim = c(1, 5), ylim = c(0, 0.4))
plot(DBH.su.crit, col = c(2, 4, 1), pch = c(1, 1, 4), lwd = c(1, 1, 2), 
    type.crit = 'o', legend = c(1, 0.4), lty = 1, xlim = c(1, 5), 
    ylim = c(0, 0.4))

}
