\name{fAssoctable}
\alias{fAssoctable}
\title{
Convert nearest neighbour object into a dataset of expected groups which is compatible with SOCPROG 2.4
}
\description{
This function converts a nearest neighbour (code{nb}) object into a format which can be accepted by the SOCPROG 2.4 program (Whitehead 2009). The output table generated by this function creates a series of 'expected' associations according to what would be expected if individuals within a population distributed themselves at random within their home range. Random points may be determined within a home range polygon or according to a probability surface within an individual's utilisation distribution. The output table is a dataframe with a group identifier (i.e. those individuals occurring within a defined distance threshold) and each line corresponding to a different individual. 
Note, the running time of this function is positively related to the number of associations in the system. Running time can be decreased by reducing the numbers of individuals contained in the study or by decreasing the association distance range in variables d1 and d2.
}
\usage{
fAssoctable(dnndata)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dnndata}{
a nb type object
}
}

\value{
\item{Group }{a numeric vector containing the group identifier}
\item{IDs }{a character vector containing the individuals in the study}
}

\author{
Ross Dwyer \email{ross.dwyer@uq.edu.au}
}

\seealso{
\code{\link{fAssocmatrix}}, \code{\link{fAssocplot}}
}

\examples{

## Load required packages 
library(adehabitatHR)

## Load study data
data(StudyArea)
data(Roos)

## Convert into a spatial object
coordinates(Roos) <- ~x+y

## Estimation of UD and KUD 95% for the 10 animals
ud <- kernelUD(Roos,h="href",same4all=TRUE)
ver95 <- getverticeshr(ud,95,unin = c("m"),unout=c("ha"))
udsgdf <- as(estUDm2spixdf(ud),"SpatialGridDataFrame")

## For all 10 individuals, extract probability weighted random points 
## falling within their respective utilisation distributions
ranXY <- fRanXY(1:10,udsgdf)
coordinates(ranXY) <- ~x+y

## Run Nearest neighbour function with those interactions < 50 m to generate the nb object
## See ?dnearneigh in the spdep package for more information
Gprox <- 50
dnn_digi <- dnearneigh(ranXY,d1=0,d2=Gprox, row.names=as.character(ranXY$ID))

## Convert random points into a dataset of expected groups by detecting associations
## by proximity and converting them into a format accepted by SOCPROG 2.4
fAssoctable(dnn_digi) 
}

