% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/DiffCorr.R
\name{plotClusterMolecules}
\alias{plotClusterMolecules}
\title{Plot cluster molecules}
\usage{
plotClusterMolecules(data, groups = NULL, group.no = NULL, title = NULL,
  ylim = NULL, order = NULL, scale.center = FALSE, scale.scale = FALSE,
  frame = "white", col = NULL, bottom.mar = 5, xlab = "Samples",
  ylab = "Relative abundance")
}
\arguments{
\item{data}{data matrix or data frame}

\item{groups}{a vector of group memberships as returned by cutree}

\item{group.no}{the group number to be plotted}

\item{title}{a title for the graph}

\item{ylim}{a vector indicating the upper and lower limit for the y-axis}

\item{order}{whether or not to order the columns of the data matrix}

\item{scale.center}{unless NULL, each row is scaled using scale}

\item{scale.scale}{unless NULL, each row is scaled using scale.}

\item{frame}{the color of the frame that is drawn as the background of the plot}

\item{col}{If NULL, all genes will be drawn in the default color (blue).
If the text "random" is given, then a set of colors will be generated by}

\item{bottom.mar}{The size of the bottom margin of the plots as sent in par(mar=c(...))}

\item{xlab}{a lalel of x axis (defalt: "Samples")}

\item{ylab}{a lalel of y axis (defalt: "Relative abundance")}
}
\value{
a graph
}
\description{
Plot cluster molecules
}
\examples{
library(pcaMethods)
data(golub, package = "multtest")
hc.mol1 <- cluster.molecule(golub[, 1:27], "pearson", "average")
g1 <- cutree(hc.mol1, h=0.4)
plotClusterMolecules(golub[,1:27], g1, 3)
}
\author{
Atsushi Fukushima
}
\references{
this function was originally from Watson M (2005) BMC Bioinformatics 7:509
}

