% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_edge_attrs.R
\name{drop_edge_attrs}
\alias{drop_edge_attrs}
\title{Drop an edge attribute column}
\usage{
drop_edge_attrs(graph, edge_attr)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{edge_attr}{the name of the edge attribute
column to drop.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
Within a graph's internal edge data
frame (edf), remove an existing edge attribute.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 5, m = 6,
    set_seed = 23) \%>\%
  set_edge_attrs(
    edge_attr = value,
    values = 3) \%>\%
  mutate_edge_attrs(
    penwidth = value * 2)

# Get the graph's internal edf to show which
# edge attributes are available
get_edge_df(graph)
#>   id from to  rel value penwidth
#> 1  1    2  3 <NA>     3        6
#> 2  2    3  5 <NA>     3        6
#> 3  3    3  4 <NA>     3        6
#> 4  4    2  4 <NA>     3        6
#> 5  5    2  5 <NA>     3        6
#> 6  6    4  5 <NA>     3        6

# Drop the `value` edge attribute
graph <-
  graph \%>\%
  drop_edge_attrs(
    edge_attr = value)

# Get the graph's internal edf to show that
# the edge attribute `value` had been removed
get_edge_df(graph)
#>   id from to  rel penwidth
#> 1  1    2  3 <NA>        6
#> 2  2    3  5 <NA>        6
#> 3  3    3  4 <NA>        6
#> 4  4    2  4 <NA>        6
#> 5  5    2  5 <NA>        6
#> 6  6    4  5 <NA>        6
}
