% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_global_graph_attr.R
\name{set_global_graph_attr}
\alias{set_global_graph_attr}
\title{Set global graph attributes}
\usage{
set_global_graph_attr(graph, type, attr_for_type, value)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph} that is created using
\code{create_graph}.}

\item{type}{the specific type of global graph attribute to set. The type is
specified with \code{graph}, \code{node}, or \code{edge}.}

\item{attr_for_type}{the name of the attribute to set for the \code{type}
of global attribute specified.}

\item{value}{the value to be set for the chosen attribute specified in the
\code{attr_for_type} argument.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Set global attributes of a specific type (either
\code{graph_attrs}, \code{node_attrs}, or \code{edge_attrs} for a graph
object of class \code{dgr_graph}.
}
\examples{
\dontrun{
library(magrittr)

# Create a new graph and set some global attributes
graph <- create_graph() \%>\%
  set_global_graph_attr("graph", "overlap", "true") \%>\%
  set_global_graph_attr("node", "fontname", "Helvetica") \%>\%
  set_global_graph_attr("edge", "color", "gray")

# Verify that the global attributes have been set
get_global_graph_attr(graph)
#> $graph_attrs
#> [1] "overlap = true"
#>
#> $node_attrs
#> [1] "fontname = Helvetica"
#>
#> $edge_attrs
#> [1] "color = gray"
}
}

