% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_node.R
\name{delete_node}
\alias{delete_node}
\title{Delete a node from an existing graph object}
\usage{
delete_node(graph, node)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph} that is created using \code{create_graph}.}

\item{node}{a node ID for the node to be deleted from the graph.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, delete an existing node by specifying its node ID.
}
\examples{
\dontrun{
# Create an empty graph
graph <- create_graph()

# Add two nodes
graph <- add_node(graph, node = "a")
graph <- add_node(graph, node = "b")

# Delete a node
graph <- delete_node(graph, node = "a")
}
}

