% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqWH.R
\name{freqWH}
\alias{freqWH}
\title{Distribution of frequency}
\usage{
freqWH(x, op = FALSE)
}
\arguments{
\item{x}{Numeric or Character. A vector of the data set.}

\item{op}{Logical. Optional argument to see the data structure in graphical representation.}
}
\value{
A data frame is returned by default (op=FALSE), including the absolute and relative frequeincies of the data set.
In addition, cumulative fequencies are included in this table. When "op=TRUE", the function returns only the absolute and relative
frequencies in a graphical representation through histogram.
}
\description{
Function used to compute the absolute and relative frecuency of a categorical variable.
}
\details{
This function shows a table including the frequency of values from a categorical vector. This vector can be formed by numeric,
character or mixed values, that is, numerical and character values. The table also includes the number of categories in which data
is distributed. The absolute and relative frecuencies can be showed using histogram.
}
\examples{
#Example 1
data1=c("A","A","A","A",2,3,2,3,"B","B","B")   
freqWH(data1)
#Example 2
data2=c("A","A","B","A","C")
freqWH(data2)
#Example 3
data3=c(5,5,3,1,5,2,3,6,9,6,6)
freqWH(data3)
#Example 4
data4=c("A1","A2","B3","A2","C")
freqWH(data4)
}
