% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.dd}
\alias{plot.dd}
\title{Draw dd plot
Draw a complete describe display.}
\usage{
\method{plot}{dd}(x, ..., draw = TRUE, axislocation = c(0.1, 0.1),
  size = 0.9, axisgp = gpar(col = "black"), background.color = "grey90")
}
\arguments{
\item{x}{dd object to plot}

\item{...}{(unused)}

\item{draw}{draw plot, or just return grob}

\item{axislocation}{location of axes (as x and y position in npc coordinates, ie. between 0 and 1)}

\item{size}{size of plot as a proportion of the total display area (set to 1 for printed out)}

\item{axisgp}{color of the axis}

\item{background.color}{color of in the background of the plot}
}
\value{
frame grob containing all panels, note that this does not contain the title or border
}
\description{
If you want to layout multiple dd plots on the same page, you can
use \code{\link[grid]{grid.layout}}.  If you need even more control,
set \code{draw = FALSE} and then \code{\link[grid]{grid.draw}} the
resulting grob yourself.
}
\details{
This function reads a number of options directly out of the
descripedisplay datastructure.  See the examples for ways to use
these.
}
\examples{
plot(dd_example("xyplot"))
plot(dd_example("tour1d"))
plot(dd_example("tour2d"))
}
\author{
Hadley Wickham \email{h.wickham@gmail.com}
}
\keyword{internal}
