% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pval_shapiro.R
\name{pval_shapiro}
\alias{pval_shapiro}
\title{\eqn{p}-value from modified Shapiro-Wilk Normality Test}
\usage{
pval_shapiro(x, CLT = FALSE, ...)
}
\arguments{
\item{x}{\link[base]{double} \link[base]{vector}}

\item{CLT}{\link[base]{logical} scalar, whether to allow the use of Central Limit Theorem, default \code{FALSE}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \link{pval_shapiro} returns a \link[base]{double} scalar.
}
\description{
Obtain \eqn{p}-value from \link[stats]{shapiro.test},
taking into consideration of several exceptions.
}
\details{
Function \link{pval_shapiro} provides a pseudo \eqn{p}-value for several exceptions of
\link[stats]{shapiro.test}, serving as a criteria of whether robust statistics/tests need to be used
\describe{
\item{\code{length(x) < 3L}}{returns \eqn{p=0}, indicating that robust methods are needed.}
\item{\code{length(x) > 5e3L}}{returns \eqn{p=1}, indicating that no robust method is needed.  For such large sample size, robust methods could be too slow.}
\item{\code{CLT & length(x) > 30L}}{returns \eqn{p=1}, indicating that no robust method is needed because of the use of Central Limit Theorem.}
\item{all \code{x} values are \link[base]{identical} (or \link[base]{all.equal}, to be implemented in future release)}{returns \eqn{p=0}, indicating that robust methods are needed.}
\item{Otherwise}{use the \eqn{p}-value from \link[stats]{shapiro.test}.}
}
}
\examples{
pval_shapiro(rnorm(5))
sapply(with(airquality, split(Ozone, f = Month)), FUN = pval_shapiro)

}
