/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.text;

import edu.cens.text.AbstractTermFrequencyViewer;
import edu.cens.text.TermFrequencyDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.rosuda.deducer.Deducer;

public class FrequencyTotalViewer
extends AbstractTermFrequencyViewer {
    JTextField saveTotalsField = new JTextField();

    public FrequencyTotalViewer(TermFrequencyDialog termFrequencyDialog) {
        super(termFrequencyDialog);
    }

    public JPanel getOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel.add((Component)this.constructSortPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JSeparator(0), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("Save Frequencies as Variable:"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.saveTotalsField, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        JButton jButton = new JButton("Save");
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrequencyTotalViewer.this.saveTotalsAsDataFrame(FrequencyTotalViewer.this.saveTotalsField.getText());
            }
        });
        return jPanel;
    }

    protected void saveTotalsAsDataFrame(String string) {
        String string2 = "";
        String string3 = Deducer.getUniqueName((String)"freqTotals");
        string2 = string2 + string3 + " <- " + this.tfDialog.getTermFreqCall(this.getExtraTermFreqArgs()) + "\n";
        String string4 = this.tfDialog.getUseDocumentFrequency() ? "doc_freq" : "term_freq";
        string2 = string2 + string + " <- d(term=names(" + string3 + "), " + string4 + "=" + string3 + ")\n";
        string2 = string2 + "rm(" + string3 + ")";
        Deducer.execute((String)string2);
    }

    public void executeView() {
        Deducer.execute((String)("print(" + this.tfDialog.getTermFreqCall(this.getExtraTermFreqArgs()) + ");"));
    }

    public String toString() {
        return "Frequency Totals List";
    }

    public void onCorpusChange(String string) {
        if (string != null) {
            this.saveTotalsField.setText(string + ".term_freq");
        }
    }
}

