/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.rosuda.JGR.layout.AnchorConstraint;

public class MapPanel
extends JMapViewer {
    JLayeredPane pane;
    Rectangle2D.Double subsetRectangle = null;

    public MapPanel(JLayeredPane jLayeredPane) {
        this.pane = jLayeredPane;
        this.setDisplayPositionByLatLon(34.0522222, -118.2427778, 3);
        this.addControls();
    }

    protected void initializeZoomSlider() {
        ImageIcon imageIcon;
        this.zoomSlider = new JSlider(0, this.tileController.getTileSource().getMaxZoom());
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(10, 10, 30, 150);
        this.zoomSlider.setPreferredSize(new Dimension(30, 150));
        this.zoomSlider.setOpaque(false);
        int n = 18;
        try {
            imageIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("images/plus.png"));
            this.zoomInButton = new JButton(imageIcon);
        }
        catch (Exception exception) {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("sansserif", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setActionCommand("in");
        this.zoomInButton.setPreferredSize(new Dimension(n, n));
        this.zoomInButton.setBounds(4, 155, n, n);
        try {
            imageIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("images/minus.png"));
            this.zoomOutButton = new JButton(imageIcon);
        }
        catch (Exception exception) {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("sansserif", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setActionCommand("out");
        this.zoomOutButton.setPreferredSize(new Dimension(n, n));
        this.zoomOutButton.setBounds(8 + n, 155, n, n);
    }

    public int getZoomSliderLevel() {
        return this.zoomSlider.getValue();
    }

    public void addControls() {
        this.pane.add(this.zoomSlider, new AnchorConstraint(10, 0, 0, 10, 2, 0, 0, 2), 0);
        this.pane.setLayer(this.zoomSlider, 3);
        this.pane.add(this.zoomInButton, new AnchorConstraint(160, 0, 0, 4, 2, 0, 0, 2), 0);
        this.pane.setLayer(this.zoomInButton, 3);
        this.pane.add(this.zoomOutButton, new AnchorConstraint(160, 0, 0, 26, 2, 0, 0, 2), 0);
        this.pane.setLayer(this.zoomOutButton, 3);
    }

    public void addPlusListener(ActionListener actionListener) {
        this.zoomInButton.addActionListener(actionListener);
    }

    public void addMinusListener(ActionListener actionListener) {
        this.zoomOutButton.addActionListener(actionListener);
    }

    public void addSliderListener(ChangeListener changeListener) {
        this.zoomSlider.addChangeListener(changeListener);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.subsetRectangle != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.draw(this.subsetRectangle);
        }
    }

    public void drawSubsetRectangle(Coordinate coordinate, Coordinate coordinate2, boolean bl) {
        Point point = this.getMapPosition(coordinate2, false);
        int n = 10;
        if (bl) {
            int n2;
            if (point.x <= 0) {
                n2 = point.x - 0;
                n2 = Math.max(n2, -n);
                this.moveMap(n2, 0);
            } else if (point.x >= this.getWidth() - 0) {
                n2 = -(this.getWidth() - point.x);
                n2 = Math.min(n2, n);
                this.moveMap(n2, 0);
            }
        }
        Point point2 = this.getMapPosition(coordinate, false);
        Point point3 = this.getMapPosition(coordinate2, false);
        double d = Math.min(point2.x, point3.x);
        double d2 = Math.min(point2.y, point3.y);
        double d3 = Math.max(point2.x, point3.x);
        double d4 = Math.max(point2.y, point3.y);
        Point point4 = new Point((int)d, (int)d2);
        Point point5 = new Point((int)d3, (int)d4);
        this.subsetRectangle = new Rectangle2D.Double(point4.x, point4.y, point5.x - point4.x, point5.y - point4.y);
        this.repaint();
    }

    public void clearSubsetRectangle() {
        this.subsetRectangle = null;
    }
}

