/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.icon;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.util.CachedPainter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;

public class QuaquaNativeButtonStateIcon
extends CachedPainter
implements Icon {
    private OSXAquaPainter painter = new OSXAquaPainter();
    private int width;
    private int height;
    private int xoffset;
    private int yoffset;
    private static final int ARG_ACTIVE = 0;
    private static final int ARG_PRESSED = 1;
    private static final int ARG_DISABLED = 2;
    private static final int ARG_ROLLOVER = 3;
    private static final int ARG_SELECTED = 4;
    private static final int ARG_FOCUSED = 5;
    private static final int ARG_SIZE_VARIANT = 6;
    private static final int ARG_SEGPOS = 8;
    private static final int ARG_WIDGET = 11;
    private static final int ARG_TRAILING_SEPARATOR = 18;

    public QuaquaNativeButtonStateIcon(OSXAquaPainter.Widget widget, int width, int height) {
        this(widget, 0, 0, width, height);
    }

    public QuaquaNativeButtonStateIcon(OSXAquaPainter.Widget widget, int xoffset, int yoffset, int width, int height) {
        super(12);
        this.painter.setWidget(widget);
        this.xoffset = xoffset;
        this.yoffset = yoffset;
        this.width = width;
        this.height = height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        OSXAquaPainter.Size size;
        OSXAquaPainter.State state;
        AbstractButton b = null;
        ButtonModel bm = null;
        if (c instanceof AbstractButton) {
            b = (AbstractButton)c;
            bm = b.getModel();
        }
        int args = 0;
        if (QuaquaUtilities.isOnActiveWindow(c)) {
            state = OSXAquaPainter.State.active;
            args |= 1;
        } else {
            state = OSXAquaPainter.State.inactive;
        }
        if (bm != null) {
            if (bm.isArmed() && bm.isPressed()) {
                state = OSXAquaPainter.State.pressed;
                args |= 2;
            }
            if (!bm.isEnabled()) {
                state = OSXAquaPainter.State.disabled;
                args |= 4;
            }
            if (bm.isRollover()) {
                state = OSXAquaPainter.State.rollover;
                args |= 8;
            }
        }
        this.painter.setState(state);
        int value = b == null ? 1 : (b.isSelected() ? 1 : 0);
        this.painter.setValueByKey(OSXAquaPainter.Key.value, value);
        args |= value << 4;
        boolean isFocused = QuaquaUtilities.isFocused(c);
        args |= isFocused ? 32 : 0;
        this.painter.setValueByKey(OSXAquaPainter.Key.focused, isFocused ? 1.0 : 0.0);
        switch (QuaquaUtilities.getSizeVariant(c)) {
            default: {
                size = OSXAquaPainter.Size.regular;
                break;
            }
            case SMALL: {
                size = OSXAquaPainter.Size.small;
                break;
            }
            case MINI: {
                size = OSXAquaPainter.Size.mini;
            }
        }
        this.painter.setSize(size);
        args |= size.getId() << 6;
        this.paint(c, g, x, y, this.width, this.height, args |= this.painter.getWidget().getId() << 11);
    }

    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
        return new BufferedImage(w, h, 3);
    }

    protected void paintToImage(Component c, Image img, int w, int h, Object args) {
        Graphics2D ig = (Graphics2D)img.getGraphics();
        ig.setColor(new Color(0, true));
        ig.setComposite(AlphaComposite.getInstance(2));
        ig.fillRect(0, 0, img.getWidth(null), img.getHeight(null));
        ig.dispose();
        this.painter.paint((BufferedImage)img, this.xoffset, this.yoffset, this.width, this.height);
    }

    protected void paintToImage(Component c, Graphics g, int w, int h, Object args) {
        BufferedImage img = (BufferedImage)this.createImage(c, (w / 32 + 1) * 32, (h / 32 + 1) * 32, null);
        this.paintToImage(c, img, w, h, args);
        g.drawImage(img, 0, 0, null);
        img.flush();
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public static class UIResource
    extends QuaquaNativeButtonStateIcon
    implements javax.swing.plaf.UIResource {
        public UIResource(OSXAquaPainter.Widget widget, int offsetx, int offsety, int width, int height) {
            super(widget, offsetx, offsety, width, height);
        }

        public UIResource(OSXAquaPainter.Widget widget, int width, int height) {
            super(widget, width, height);
        }
    }
}

