/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.pograss;

import java.io.FileOutputStream;
import java.io.PrintStream;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.PDFconstructor;

public class PoGraSSPDF
extends PoGraSS {
    String fn;
    PrintStream outs;
    PDFconstructor p;
    StringBuffer cont;
    String[] c;
    String[] cn;
    int cs;
    int lineWidth = 1;
    int fillSt = 0;
    int ox;
    int oy;
    boolean inPath = false;
    String curFill;
    String curPen;
    String title;
    String xver = null;
    String lastBaseFont;
    String italAppendix = "Italic";
    String romAppendix = "";
    boolean lastLT = false;
    int lastX;
    int lastY;

    public PoGraSSPDF(String string) {
        this.outs = null;
        this.fn = string;
        this.curFill = "0 g ";
        this.curPen = "1 g ";
        this.title = null;
        this.ox = 0;
        this.oy = 1000;
        this.c = new String[128];
        this.cn = new String[128];
        this.cs = 0;
        this.cont = new StringBuffer();
    }

    public PoGraSSPDF(PrintStream printStream) {
        this.outs = printStream;
        this.fn = null;
        this.curFill = "0 g ";
        this.curPen = "1 g ";
        this.title = null;
        this.ox = 0;
        this.oy = 1000;
        this.c = new String[128];
        this.cn = new String[128];
        this.cs = 0;
        this.cont = new StringBuffer();
    }

    String getColor(String string) {
        for (int i = 0; i < this.cs; ++i) {
            if (this.cn[i].compareTo(string) != 0) continue;
            return this.c[i];
        }
        return "0.0 0.0 0.0";
    }

    public void defineColor(String string, String string2) {
        if (this.cs < 128) {
            this.cn[this.cs] = new String(string);
            this.c[this.cs] = new String(string2);
            ++this.cs;
        }
    }

    public void passVersionInfo(int n, String string) {
        this.xver = string;
    }

    public void setBounds(int n, int n2) {
        this.boundsWidth = n;
        this.boundsHeight = n2;
        this.ox = 0;
        this.oy = this.boundsHeight;
    }

    void outPS(String string) {
        this.cont.append(string);
    }

    public void addComment(String string) {
        this.outPS("%% -- " + string);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void defineColor(String string, int n, int n2, int n3) {
        this.defineColor(string, "" + (double)n / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n3 / 255.0);
    }

    public void setColor(int n, int n2, int n3) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.curPen = (double)n / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n3 / 255.0 + " RG ";
        this.outPS(this.curPen);
        if (this.jointColors) {
            this.outPS((double)n / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n3 / 255.0 + " rg ");
        }
    }

    public void setColor(String string) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.curPen = this.getColor(string) + " RG ";
        this.outPS(this.curPen);
        if (this.jointColors) {
            this.outPS(this.getColor(string) + " rg ");
        }
    }

    public void setFillColor(int n, int n2, int n3) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        if (n == n2 && n2 == n3) {
            this.curFill = (double)n / 255.0 + " g ";
            this.outPS(this.curFill);
        } else {
            this.curFill = (double)n / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n3 / 255.0 + " rg ";
            this.outPS(this.curFill);
        }
        if (this.jointColors) {
            if (n == n2 && n2 == n3) {
                this.outPS((double)n / 255.0 + " G ");
            } else {
                this.outPS((double)n / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n3 / 255.0 + " RG ");
            }
        }
    }

    public void setFillColor(String string) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.curFill = this.getColor(string) + " rg ";
        this.outPS(this.curFill);
        if (this.jointColors) {
            this.outPS(this.getColor(string) + " RG ");
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.moveTo(n, n2);
        this.lineTo(n3, n4);
    }

    public void moveTo(int n, int n2) {
        if (!this.inPath) {
            this.lastLT = false;
        }
        this.inPath = true;
        if (!this.lastLT || this.ox + n != this.lastX || this.oy + n2 != this.lastY) {
            this.outPS(this.ox + n + " " + (this.oy - n2) + " m ");
        }
        this.lastLT = true;
        this.lastX = this.ox + n;
        this.lastY = this.ox + n2;
    }

    public void lineTo(int n, int n2) {
        if (!this.inPath) {
            this.lastLT = false;
        }
        this.inPath = true;
        if (!this.lastLT || this.ox + n != this.lastX || this.oy + n2 != this.lastY) {
            this.outPS(this.ox + n + " " + (this.oy - n2) + " l ");
        }
        this.lastLT = true;
        this.lastX = this.ox + n;
        this.lastY = this.ox + n2;
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n, boolean bl) {
        if (n < 2) {
            return;
        }
        this.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < n; ++i) {
            this.lineTo(nArray[i], nArray2[i]);
        }
        if (bl) {
            this.lineTo(nArray[0], nArray2[0]);
        }
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        if (n < 2) {
            return;
        }
        this.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < n; ++i) {
            this.lineTo(nArray[i], nArray2[i]);
        }
        this.outPS(" f\n");
        this.inPath = false;
        this.lastLT = false;
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.moveTo(n, n2);
        this.lineTo(n + n3, n2);
        this.lineTo(n + n3, n2 + n4);
        this.lineTo(n, n2 + n4);
        this.lineTo(n, n2);
        this.outPS(" S\n");
        this.inPath = false;
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.moveTo(n, n2);
        this.lineTo(n + n3, n2);
        this.lineTo(n + n3, n2 + n4);
        this.lineTo(n, n2 + n4);
        this.lineTo(n, n2);
        this.outPS(" f\n");
        this.inPath = false;
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.outPS(" " + (this.ox + n + n3 - (n5 /= 2)) + " " + (this.oy - n2) + " m " + (this.ox + n + n3) + " " + (this.oy - n2) + " " + (this.ox + n + n3) + " " + (this.oy - n2 - n4 + (n6 /= 2)) + " v ");
        this.outPS(this.ox + n + n3 + " " + (this.oy - n2 - n4) + " " + (this.ox + n + n5) + " " + (this.oy - n2 - n4) + " v ");
        this.outPS(this.ox + n + " " + (this.oy - n2 - n4) + " " + (this.ox + n) + " " + (this.oy - n2 - n6) + " v ");
        this.outPS(this.ox + n + " " + (this.oy - n2) + " " + (this.ox + n + n3 - n5) + " " + (this.oy - n2) + " v S\n");
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.outPS(" " + (this.ox + n + n3 - (n5 /= 2)) + " " + (this.oy - n2) + " m " + (this.ox + n + n3) + " " + (this.oy - n2) + " " + (this.ox + n + n3) + " " + (this.oy - n2 - n4 + (n6 /= 2)) + " v ");
        this.outPS(this.ox + n + n3 + " " + (this.oy - n2 - n4) + " " + (this.ox + n + n5) + " " + (this.oy - n2 - n4) + " v ");
        this.outPS(this.ox + n + " " + (this.oy - n2 - n4) + " " + (this.ox + n) + " " + (this.oy - n2 - n6) + " v ");
        this.outPS(this.ox + n + " " + (this.oy - n2) + " " + (this.ox + n + n3 - n5) + " " + (this.oy - n2) + " v f\n");
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        n3 /= 2;
        n4 /= 2;
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        n3 /= 2;
        n4 /= 2;
    }

    public void setLineWidth(int n) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.lineWidth = n;
        this.outPS(" " + n + " w ");
    }

    public void setFillStyle(int n) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.fillSt = n;
    }

    public void drawString(String string, int n, int n2) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.outPS("BT /F1 " + this.lastFontSize + " Tf " + (this.ox + n) + " " + (this.oy - n2) + " Td (" + string + ") Tj ET\n");
    }

    public void drawString(String string, int n, int n2, int n3) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        String string2 = "sw";
        if ((n3 & 3) == 1) {
            string2 = "swr";
        }
        if ((n3 & 3) == 2) {
            string2 = "swc";
        }
    }

    public void drawString(String string, int n, int n2, double d, double d2) {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
    }

    public void nextLayer() {
        this.outPS("%% nextLayer\n");
    }

    public void begin() {
        if (this.fn != null) {
            try {
                this.outs = new PrintStream(new FileOutputStream(this.fn));
            }
            catch (Exception exception) {
                this.outs = null;
            }
        }
        this.p = new PDFconstructor(this.outs, 1);
        this.p.addObject("<< /Type /Catalog\n/Outlines 2 0 R\n/Pages 3 0 R\n>>");
        this.p.addObject("<< /Type /Outlines\n/Count 0\n>>");
        this.p.addObject("<< /Type /Pages\n/Kids [4 0 R]\n/Count 1\n>>");
        this.p.addObject("<< /Type /Page\n/Parent 3 0 R\n/MediaBox [0 0 " + this.boundsWidth + " " + this.boundsHeight + "]\n/Contents 5 0 R\n/Resources << /ProcSet 6 0 R\n/Font << /F1 7 0 R >>\n>>\n>>");
        this.lastFontSize = 10.0;
        this.lastFontAttr = 0;
        this.lastFont = 1;
        this.lastFace = "Helvetica";
        this.lastBaseFont = "Helvetica";
        this.italAppendix = "Oblique";
        this.romAppendix = "";
    }

    public void end() {
        if (this.inPath) {
            this.outPS(" S\n");
        }
        this.inPath = false;
        this.lastLT = false;
        this.p.addObject(PDFconstructor.asStream(this.cont.toString()));
        this.p.addObject("[/PDF /Text]");
        this.p.addObject("<< /Type /Font\n/Subtype /Type1\n/Name /F1\n/BaseFont /Helvetica\n/Encoding /MacRomanEncoding\n>>");
        this.p.end(1);
    }

    public void closePSoutput() {
        if (this.outs != null) {
            this.outs.close();
            this.outs = null;
        }
    }

    public void setFontFace(int n) {
        this.lastBaseFont = "Helvetica";
        this.romAppendix = "";
        this.italAppendix = "Oblique";
        if (n == 2) {
            this.lastBaseFont = "Time";
            this.romAppendix = "-Roman";
            this.italAppendix = "Italic";
        }
        if (n == 3) {
            this.lastBaseFont = "Courier";
        }
        this.lastFont = n;
        if (this.inPath) {
            this.outPS(" cp s\n");
        }
        this.inPath = false;
        this.internal_setFontStyle(this.lastFontAttr);
    }

    public void setOptionalFace(String string) {
        if (this.inPath) {
            this.outPS(" cp s\n");
        }
        this.inPath = false;
        this.lastFace = string;
    }

    public void setFontSize(int n) {
        if (this.inPath) {
            this.outPS(" cp s\n");
        }
        this.inPath = false;
        this.lastFontSize = n;
    }

    void internal_setFontStyle(int n) {
        this.lastFace = this.lastBaseFont + this.romAppendix;
        this.lastFontAttr = n;
        if ((n & 7) == 2) {
            this.lastFace = this.lastBaseFont + "-Bold";
        }
        if ((n & 7) == 1) {
            this.lastFace = this.lastBaseFont + "-" + this.italAppendix;
        }
    }

    public void setFontStyle(int n) {
        if (this.inPath) {
            this.outPS(" cp s\n");
        }
        this.inPath = false;
        this.internal_setFontStyle(n);
    }
}

