/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.View;

public class QuaquaUtilities
extends BasicGraphicsUtils
implements SwingConstants {
    private static final boolean DEBUG = false;
    private static String swingUtilities2;

    private QuaquaUtilities() {
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    public static void drawStringUnderlineCharAt(Graphics g, String text, int underlinedIndex, int x, int y) {
        g.drawString(text, x, y);
        if (underlinedIndex >= 0 && underlinedIndex < text.length()) {
            FontMetrics fm = g.getFontMetrics();
            int underlineRectX = x + fm.stringWidth(text.substring(0, underlinedIndex));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
    }

    static int findDisplayedMnemonicIndex(String text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc);
        int lci = text.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public static boolean isOnActiveWindow(Component c) {
        return QuaquaUtilities.isOnActiveWindow(c, false);
    }

    public static boolean isOnActiveWindow(Component c, boolean isActiveWhenSheetIsActive) {
        boolean isOnActiveWindow;
        Boolean value;
        if (c instanceof JComponent && (value = (Boolean)((JComponent)c).getClientProperty("Frame.active")) != null && value.booleanValue()) {
            return true;
        }
        Window window = SwingUtilities.getWindowAncestor(c);
        if (window == null) {
            isOnActiveWindow = true;
        } else if (window instanceof JWindow) {
            isOnActiveWindow = window.isActive() || window.getName() == "###focusableSwingPopup###";
        } else if (window instanceof Frame || window instanceof Dialog) {
            isOnActiveWindow = window.isActive();
            if (!isOnActiveWindow && isActiveWhenSheetIsActive) {
                Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                isOnActiveWindow = focusedWindow != null && focusedWindow.getOwner() == window;
                return isOnActiveWindow;
            }
        } else {
            isOnActiveWindow = window.getFocusableWindowState() ? window.isFocused() : true;
        }
        if (isOnActiveWindow && c instanceof JComponent) {
            ((JComponent)c).putClientProperty("Frame.active", isOnActiveWindow);
        }
        return isOnActiveWindow;
    }

    public static String getKeyModifiersText(int modifiers, boolean leftToRight) {
        return QuaquaUtilities.getKeyModifiersUnicode(modifiers, leftToRight);
    }

    static String getKeyModifiersUnicode(int modifiers, boolean leftToRight) {
        char[] cs = new char[4];
        int count = 0;
        if (leftToRight) {
            if ((modifiers & 2) != 0) {
                cs[count++] = 8963;
            }
            if ((modifiers & 0x28) != 0) {
                cs[count++] = 8997;
            }
            if ((modifiers & 1) != 0) {
                cs[count++] = 8679;
            }
            if ((modifiers & 4) != 0) {
                cs[count++] = 8984;
            }
        } else {
            if ((modifiers & 4) != 0) {
                cs[count++] = 8984;
            }
            if ((modifiers & 1) != 0) {
                cs[count++] = 8679;
            }
            if ((modifiers & 0x28) != 0) {
                cs[count++] = 8997;
            }
            if ((modifiers & 2) != 0) {
                cs[count++] = 8963;
            }
        }
        return new String(cs, 0, count);
    }

    public static void repaintBorder(JComponent component) {
        JComponent c = component;
        Border border = null;
        Container container = component.getParent();
        if (container instanceof JViewport && (c = (JComponent)container.getParent()) != null) {
            border = c.getBorder();
        }
        if (border == null) {
            border = component.getBorder();
            c = component;
        }
        if (border != null && c != null) {
            int w = c.getWidth();
            int h = c.getHeight();
            Insets insets = c.getInsets();
            c.repaint(0, 0, w, insets.top);
            c.repaint(0, insets.top, insets.left, h - insets.bottom - insets.top);
            c.repaint(0, h - insets.bottom, w, insets.bottom);
            c.repaint(w - insets.right, insets.top, insets.right, h - insets.bottom - insets.top);
        }
    }

    public static Object beginGraphics(Graphics2D graphics2d) {
        Object object = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return object;
    }

    public static void endGraphics(Graphics2D graphics2d, Object oldHints) {
        if (oldHints != null) {
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldHints);
        }
    }

    public static boolean isFocused(Component component) {
        if (component instanceof JComponent && ((JComponent)component).getClientProperty("Quaqua.Component.cellRendererFor") != null) {
            component = (Component)((JComponent)component).getClientProperty("Quaqua.Component.cellRendererFor");
        }
        try {
            boolean isFocusOwner = (Boolean)Methods.invoke(component, "isFocusOwner");
            Window ancestor = SwingUtilities.getWindowAncestor(component);
            Object kfm = Methods.invokeStatic("java.awt.KeyboardFocusManager", "getCurrentKeyboardFocusManager");
            return isFocusOwner || component == Methods.invoke(kfm, "getPermanentFocusOwner") && ancestor != null && Methods.invokeGetter((Object)ancestor, "isFocused", false);
        }
        catch (NoSuchMethodException e) {
            return component.hasFocus();
        }
    }

    static boolean isHeadless() {
        return Methods.invokeStaticGetter(GraphicsEnvironment.class, "isHeadless", false);
    }

    private static String getSwingUtilities2() {
        if (swingUtilities2 == null) {
            swingUtilities2 = "sun.swing.SwingUtilities2";
            try {
                Class.forName(swingUtilities2);
            }
            catch (ClassNotFoundException ex) {
                swingUtilities2 = "com.sun.java.swing.SwingUtilities2";
                try {
                    Class.forName(swingUtilities2);
                }
                catch (ClassNotFoundException ex2) {
                    System.err.println("Warning QuaquaUtilities: Couldn't locate class " + swingUtilities2);
                }
            }
        }
        return swingUtilities2;
    }

    public static int getLeftSideBearing(Font f, String string) {
        return (Integer)Methods.invokeStatic(QuaquaUtilities.getSwingUtilities2(), "getLeftSideBearing", new Class[]{Font.class, String.class}, new Object[]{f, string}, 0);
    }

    static void provideErrorFeedback(Component component) {
        Toolkit toolkit = null;
        toolkit = component != null ? component.getToolkit() : Toolkit.getDefaultToolkit();
        toolkit.beep();
    }

    public static BufferedImage createBufferedImage(URL location) {
        BufferedImage buf;
        Image image = Toolkit.getDefaultToolkit().createImage(location);
        if (image instanceof BufferedImage) {
            buf = (BufferedImage)image;
        } else {
            QuaquaUtilities.loadImage(image);
            buf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics g = buf.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            image.flush();
        }
        return buf;
    }

    public static TexturePaint createTexturePaint(URL location) {
        BufferedImage texture = QuaquaUtilities.createBufferedImage(location);
        TexturePaint paint = new TexturePaint(texture, new Rectangle(0, 0, texture.getWidth(), texture.getHeight()));
        return paint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadImage(Image image) {
        MediaTracker tracker;
        Component component = new Component(){};
        MediaTracker mediaTracker = tracker = new MediaTracker(component);
        synchronized (mediaTracker) {
            int id = 0;
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            tracker.removeImage(image, id);
        }
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return QuaquaUtilities.layoutCompoundLabelImpl(c, fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        return QuaquaUtilities.layoutCompoundLabelImpl(null, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int availTextWidth;
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        int lsb = 0;
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = (int)v.getPreferredSpan(0);
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                textR.width = SwingUtilities.computeStringWidth(fm, text);
                lsb = QuaquaUtilities.getLeftSideBearing(fm.getFont(), text);
                if (lsb < 0) {
                    textR.width -= lsb;
                }
                textR.height = fm.getHeight();
            }
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.width > (availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap))) {
            if (v != null) {
                textR.width = availTextWidth;
            } else {
                int nChars;
                String clipString = "...";
                int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
                int len = text.length();
                for (nChars = 0; nChars < len; ++nChars) {
                    int charIndex;
                    int n2 = charIndex = nChars % 2 == 0 ? nChars / 2 : len - 1 - nChars / 2;
                    if ((totalWidth += fm.charWidth(text.charAt(charIndex))) > availTextWidth) break;
                }
                text = text.substring(0, nChars / 2) + clipString + text.substring(len - nChars / 2);
                textR.width = SwingUtilities.computeStringWidth(fm, text);
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        if (lsb < 0) {
            textR.width += lsb;
            textR.x -= lsb;
        }
        return text;
    }

    static void setWindowAlpha(Window w, int value) {
        if (w == null) {
            return;
        }
        if (w instanceof RootPaneContainer) {
            JRootPane rp = ((RootPaneContainer)((Object)w)).getRootPane();
            rp.putClientProperty("Window.alpha", new Float((float)value / 255.0f));
        }
    }

    static void setWindowAlphaOld(Window w, int value) {
        block11: {
            if (w == null) {
                return;
            }
            if (QuaquaManager.isOSX()) {
                if (w.getPeer() == null) {
                    w.pack();
                }
                ComponentPeer peer = w.getPeer();
                try {
                    Methods.invoke((Object)peer, "setAlpha", (float)value / 255.0f);
                    w.setBackground(new Color(255, 255, 255, value));
                    if (w instanceof RootPaneContainer) {
                        ((RootPaneContainer)((Object)w)).getContentPane().setBackground(new Color(255, 255, 255, 0));
                    }
                    break block11;
                }
                catch (Throwable e) {
                    if (!QuaquaManager.getProperty("java.version").startsWith("1.3")) break block11;
                    try {
                        Methods.invoke((Object)peer, "_setAlpha", value);
                        break block11;
                    }
                    catch (Throwable e2) {
                        w.setBackground(new Color(255, 255, 255, value));
                        if (w instanceof RootPaneContainer) {
                            ((RootPaneContainer)((Object)w)).getContentPane().setBackground(new Color(255, 255, 255, 0));
                        }
                        break block11;
                    }
                }
            }
            try {
                Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
                method.invoke(clazz, w, Boolean.FALSE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Component compositeRequestFocus(Component component) {
        try {
            if (component instanceof Container) {
                Object policy;
                Component comp;
                Object policy2;
                Component comp2;
                Container container = (Container)component;
                if (Methods.invokeGetter((Object)container, "isFocusCycleRoot", false) && (comp2 = (Component)Methods.invoke(policy2 = Methods.invokeGetter((Object)container, "getFocusTraversalPolicy", null), "getDefaultComponent", Container.class, container)) != null) {
                    comp2.requestFocus();
                    return comp2;
                }
                Container rootAncestor = (Container)Methods.invokeGetter((Object)container, "getFocusCycleRootAncestor", null);
                if (rootAncestor != null && (comp = (Component)Methods.invoke(policy = Methods.invokeGetter((Object)rootAncestor, "getFocusTraversalPolicy", null), "getComponentAfter", new Class[]{Container.class, Component.class}, new Object[]{rootAncestor, container})) != null && SwingUtilities.isDescendingFrom(comp, container)) {
                    comp.requestFocus();
                    return comp;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (Methods.invokeGetter((Object)component, "isFocusable", true)) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    public static void installProperty(JComponent c, String propertyName, Object value) {
        LookAndFeel.installProperty(c, propertyName, value);
    }

    public static Object getUIOfType(ComponentUI ui, Class klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public static void adjustFocus(JComponent tree) {
        try {
            Methods.invokeStatic(QuaquaUtilities.getSwingUtilities2(), "adjustFocus", JComponent.class, (Object)tree);
        }
        catch (NoSuchMethodException ex) {
            tree.requestFocusInWindow();
        }
    }

    static boolean shouldIgnore(MouseEvent e, JComponent tree) {
        try {
            return (Boolean)Methods.invokeStatic(QuaquaUtilities.getSwingUtilities2(), "shouldIgnore", new Class[]{MouseEvent.class, JComponent.class}, new Object[]{e, tree});
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public static SizeVariant getSizeVariant(Component c) {
        Font f;
        JComponent jc;
        String p;
        if (c == null) {
            return SizeVariant.REGULAR;
        }
        SizeVariant sv = null;
        if (c instanceof JComponent && (p = (String)(jc = (JComponent)c).getClientProperty("JComponent.sizeVariant")) != null) {
            if (p.equals("large")) {
                sv = SizeVariant.LARGE;
            } else if (p.equals("regular")) {
                sv = SizeVariant.REGULAR;
            } else if (p.equals("small")) {
                sv = SizeVariant.SMALL;
            } else if (p.equals("mini")) {
                sv = SizeVariant.MINI;
            }
        }
        if (sv == null && (c instanceof TableCellRenderer || c instanceof TableCellEditor || c.getParent() instanceof JTable)) {
            sv = SizeVariant.SMALL;
        }
        if (sv == null && (f = c.getFont()) != null) {
            int fs = f.getSize();
            sv = fs <= 9 ? SizeVariant.MINI : (fs <= 11 ? SizeVariant.SMALL : (fs <= 14 ? SizeVariant.REGULAR : SizeVariant.LARGE));
        }
        return sv == null ? SizeVariant.REGULAR : sv;
    }

    public static Font getSizeVariantFont(JComponent c) {
        Font font = c.getFont();
        if (font == null || font instanceof UIResource) {
            String bstyle;
            switch (QuaquaUtilities.getSizeVariant(c)) {
                default: {
                    font = UIManager.getFont("SystemFont");
                    break;
                }
                case SMALL: {
                    font = UIManager.getFont("SmallSystemFont");
                    break;
                }
                case MINI: {
                    font = UIManager.getFont("MiniSystemFont");
                }
            }
            String pstyle = (String)c.getClientProperty("Quaqua.Tree.style");
            if (pstyle != null && (pstyle.equals("sideBar") || pstyle.equals("sourceList"))) {
                font = UIManager.getFont("Tree.sideBar.selectionFont");
            }
            if ((bstyle = (String)c.getClientProperty("Quaqua.Button.style")) == null) {
                bstyle = (String)c.getClientProperty("JButton.buttonType");
            }
            if (bstyle != null && bstyle.equals("tableHeader")) {
                font = UIManager.getFont("TableHeader.font");
            }
        }
        return font == null ? UIManager.getFont("SystemFont") : font;
    }

    public static void applySizeVariant(JComponent c) {
        Font font = QuaquaUtilities.getSizeVariantFont(c);
        c.setFont(font);
    }

    public static int getDragThreshold() {
        try {
            Integer value = (Integer)Methods.invokeStatic(DragSource.class, "getDragThreshold");
            return value;
        }
        catch (Throwable ex) {
            return 5;
        }
    }

    public static int mapDragOperationFromModifiers(MouseEvent me, TransferHandler th) {
        return QuaquaUtilities.convertModifiersToDropAction(me.getModifiersEx(), th.getSourceActions((JComponent)me.getSource()));
    }

    public static int convertModifiersToDropAction(int modifiers, int supportedActions) {
        int dropAction = 0;
        switch (modifiers & 0xC0) {
            case 192: {
                dropAction = 0x40000000;
                break;
            }
            case 128: {
                dropAction = 1;
                break;
            }
            case 64: {
                dropAction = 2;
                break;
            }
            default: {
                if ((supportedActions & 2) != 0) {
                    dropAction = 2;
                    break;
                }
                if ((supportedActions & 1) != 0) {
                    dropAction = 1;
                    break;
                }
                if ((supportedActions & 0x40000000) == 0) break;
                dropAction = 0x40000000;
            }
        }
        return dropAction & supportedActions;
    }

    public static Component findFocusOwner(Component c) {
        Component focusOwner;
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (temp != null) {
            if (temp == c) {
                return focusOwner;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        return null;
    }

    public static boolean isOnTexturedWindow(Component c) {
        JRootPane rootPane = SwingUtilities.getRootPane(c);
        boolean isTextured = rootPane != null ? rootPane.getClientProperty("apple.awt.brushMetalLook") == Boolean.TRUE : false;
        return isTextured;
    }

    public static Rectangle getVisualBounds(Component c, int type) {
        JComponent jc;
        ComponentUI ui;
        if (c instanceof JComponent && (ui = (ComponentUI)Methods.invokeGetter((Object)(jc = (JComponent)c), "getUI", null)) instanceof VisuallyLayoutable) {
            VisuallyLayoutable vl = (VisuallyLayoutable)((Object)ui);
            return vl.getVisualBounds(jc, type, jc.getWidth(), jc.getHeight());
        }
        return type == 0 ? new Rectangle(0, 0, c.getWidth(), c.getHeight()) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SizeVariant {
        LARGE(3),
        REGULAR(2),
        SMALL(1),
        MINI(0);

        int id;

        private SizeVariant(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

