/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.ExCellRenderer;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.deducer.data.RowNamesListModel;

public class RDataFrameModel
extends ExDefaultTableModel {
    private static String guiEnv = Deducer.guiEnv;
    private static int numPageRows = 500;
    private static int numPageCols = 10;
    private static int maxPages = 10;
    public static String NA_STRING = "*$_$_$_$$NA$$_$_$_$*";
    private String rDataName = null;
    private String tempDataName = null;
    RowNamesModel rowNamesModel = new RowNamesModel();
    volatile ArrayList pages = new ArrayList();
    volatile ArrayList pageLocations = new ArrayList();
    volatile HashSet pendingPages = new HashSet();
    int ncol = 0;
    int nrow = 0;
    int[] classes = new int[0];
    public static final int numExtensionRows = 15;
    public static final int numExtensionColumns = 4;

    public RDataFrameModel() {
    }

    public RDataFrameModel(String string) {
        this.setDataName(string);
    }

    public String getDataName() {
        return this.rDataName;
    }

    public void setDataName(String string) {
        boolean bl = ((REXPLogical)Deducer.eval("'" + guiEnv + "' %in% .getOtherObjects()")).isTRUE()[0];
        if (!bl) {
            Deducer.eval(guiEnv + "<-new.env(parent=emptyenv())");
        }
        if (this.tempDataName != null) {
            this.removeCachedData();
        }
        this.rDataName = string;
        if (this.rDataName != null) {
            this.tempDataName = Deducer.getUniqueName(this.rDataName + Math.random(), guiEnv);
            try {
                Deducer.eval(guiEnv + "$" + this.tempDataName + "<-" + this.rDataName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.populateMetaData();
        }
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void populateMetaData() {
        try {
            int[] nArray = Deducer.eval("dim(" + this.rDataName + ")").asIntegers();
            this.nrow = nArray[0];
            this.ncol = nArray[1];
            String[] stringArray = null;
            try {
                stringArray = Deducer.eval("sapply(" + this.rDataName + ",function(x){a <- class(x);return(a[length(a)])})").asStrings();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray == null) {
                stringArray = new String[this.ncol];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = "numeric";
                }
            }
            this.classes = new int[this.ncol];
            for (int i = 0; i < this.ncol; ++i) {
                this.classes[i] = stringArray[i].equals("numeric") ? 0 : (stringArray[i].equals("integer") ? 1 : (stringArray[i].equals("logical") ? 2 : (stringArray[i].equals("factor") ? 3 : (stringArray[i].equals("character") ? 4 : 5))));
            }
        }
        catch (Exception exception) {
            this.nrow = 0;
            this.ncol = 0;
            this.classes = new int[0];
            exception.printStackTrace();
        }
    }

    public int getColumnCount() {
        if (this.rDataName != null) {
            return this.ncol + 4;
        }
        return 0;
    }

    public int getRealColumnCount() {
        if (this.rDataName != null) {
            return this.ncol;
        }
        return 0;
    }

    public int getRealRowCount() {
        if (this.rDataName != null) {
            return this.nrow;
        }
        return 0;
    }

    public int getRowCount() {
        if (this.rDataName != null) {
            return this.nrow + 15;
        }
        return 0;
    }

    public void removeColumn(int n) {
        if (n < this.getRealColumnCount()) {
            Deducer.eval(this.rDataName + "<-" + this.rDataName + "[,-" + (n + 1) + "]");
            this.refresh();
        }
    }

    public void removeRow(int n) {
        if (n + 1 <= this.getRealRowCount()) {
            Deducer.eval(this.rDataName + "<- " + this.rDataName + "[-" + (n + 1) + ",]");
            this.refresh();
        }
    }

    public void insertNewColumn(int n) {
        if (n > this.getRealColumnCount() + 1) {
            return;
        }
        if (n < 1) {
            Deducer.eval(this.rDataName + "<-data.frame(V=as.integer(NA)," + this.rDataName + "[," + (n + 1) + ":" + this.getRealColumnCount() + ",drop=FALSE])");
        } else if (n >= this.getRealColumnCount()) {
            Deducer.eval(this.rDataName + "<-data.frame(" + this.rDataName + ",V=as.integer(NA))");
        } else {
            Deducer.eval(this.rDataName + "<-data.frame(" + this.rDataName + "[,1:" + n + ",drop=FALSE],V=as.integer(NA)," + this.rDataName + "[," + (n + 1) + ":" + this.getRealColumnCount() + ",drop=FALSE])");
        }
        this.refresh();
    }

    public void insertNewRow(int n) {
        int n2 = this.getRealRowCount();
        this.setValueAt("NA", Math.max(n2, n), 0);
        Deducer.eval("attr(" + this.rDataName + ",'row.names')[" + (Math.max(n2, n) + 1) + "]<-'New'");
        if (n < 1) {
            Deducer.eval(this.rDataName + "<-rbind(" + this.rDataName + "[" + (n2 + 1) + ",]," + this.rDataName + "[" + (n + 1) + ":" + n2 + ",,drop=FALSE])");
        } else if (n < n2) {
            Deducer.eval(this.rDataName + "<-rbind(" + this.rDataName + "[1:" + n + ",,drop=FALSE]," + this.rDataName + "[" + (n2 + 1) + ",]," + this.rDataName + "[" + (n + 1) + ":" + n2 + ",,drop=FALSE])");
        }
        Deducer.eval("rownames(" + this.rDataName + ")<-make.unique(rownames(" + this.rDataName + "))");
    }

    public String getPageValue(int n, int n2) {
        for (int i = 0; i < this.pageLocations.size(); ++i) {
            int[] nArray = (int[])this.pageLocations.get(i);
            if (n < nArray[0] || n >= nArray[0] + numPageRows || n2 < nArray[1] || n2 >= nArray[1] + numPageCols) continue;
            String[][] stringArray = (String[][])this.pages.get(i);
            return stringArray[n2 - nArray[1]][n - nArray[0]];
        }
        return null;
    }

    public boolean setPageValue(String string, int n, int n2) {
        for (int i = 0; i < this.pageLocations.size(); ++i) {
            int[] nArray = (int[])this.pageLocations.get(i);
            if (n < nArray[0] || n >= nArray[0] + numPageRows || n2 < nArray[1] || n2 >= nArray[1] + numPageCols) continue;
            String[][] stringArray = (String[][])this.pages.get(i);
            stringArray[n2 - nArray[1]][n - nArray[0]] = string;
            return true;
        }
        return false;
    }

    public void lazyLoad(int n, int n2) {
        final int n3 = n / numPageRows * numPageRows;
        final int n4 = n2 / numPageCols * numPageCols;
        if (!this.pending(n3, n4)) {
            new Thread(new Runnable(){

                public void run() {
                    RDataFrameModel.this.loadPage(n3, n4);
                }
            }).start();
        }
    }

    public boolean pending(int n, int n2) {
        int n3 = n * n2 * (n > n2 ? 1 : -1);
        return !this.pendingPages.add(new Integer(n3));
    }

    public boolean isPending(int n, int n2) {
        int n3 = n * n2 * (n > n2 ? 1 : -1);
        return this.pendingPages.contains(new Integer(n3));
    }

    public void declarePending(int n, int n2) {
        int n3 = n * n2 * (n > n2 ? 1 : -1);
        this.pendingPages.add(new Integer(n3));
    }

    public void removePending(int n, int n2) {
        int n3 = n * n2 * (n > n2 ? 1 : -1);
        this.pendingPages.remove(new Integer(n3));
    }

    public void loadPage(int n, int n2) {
        int n3;
        String[][] stringArray = new String[numPageCols][numPageRows];
        for (int i = 0; i < numPageCols; ++i) {
            int n4;
            String[] stringArray2 = null;
            if (i >= this.ncol - n2 || n >= this.nrow) {
                stringArray2 = new String[numPageRows];
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    stringArray2[n3] = "";
                }
            } else {
                try {
                    stringArray2 = Deducer.eval("format(" + this.rDataName + "[(" + (n + 1) + "):(" + Math.min(this.nrow, n + numPageRows + 1) + ")," + (i + n2 + 1) + "])").asStrings();
                    boolean[] blArray = Deducer.eval(this.rDataName + "[(" + (n + 1) + "):(" + Math.min(this.nrow, n + numPageRows + 1) + ")," + (i + n2 + 1) + "]").isNA();
                    for (n4 = 0; n4 < blArray.length; ++n4) {
                        if (!blArray[n4]) continue;
                        stringArray2[n4] = NA_STRING;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (stringArray2 != null) {
                if (stringArray2.length < numPageRows) {
                    String[] stringArray3 = new String[numPageRows];
                    for (n4 = 0; n4 < numPageRows; ++n4) {
                        stringArray3[n4] = n4 < stringArray2.length ? stringArray2[n4] : "";
                    }
                    stringArray2 = stringArray3;
                }
                stringArray[i] = stringArray2;
                continue;
            }
            stringArray2 = new String[numPageRows];
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                stringArray2[n3] = "";
            }
            stringArray[i] = stringArray2;
        }
        this.pages.add(stringArray);
        int[] nArray = new int[]{n, n2};
        this.pageLocations.add(nArray);
        if (this.pages.size() > maxPages) {
            this.pages.remove(0);
            this.pageLocations.remove(0);
        }
        this.removePending(n, n2);
        for (int i = n; i < n + numPageRows; ++i) {
            for (n3 = n2; n3 < n2 + numPageCols; ++n3) {
                this.fireTableCellUpdated(i, n3);
            }
        }
    }

    public Object getValueAt(int n, int n2) {
        String string = this.getPageValue(n, n2);
        if (string != null) {
            return string;
        }
        this.lazyLoad(n, n2);
        return "";
    }

    public Object getActualValueAt(int n, int n2) {
        String string = this.getPageValue(n, n2);
        if (string != null) {
            return string;
        }
        try {
            return Deducer.eval("format(" + this.rDataName + "[(" + (n + 1) + ")," + (n2 + 1) + "])").asString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!this.isCellEditable(n, n2)) {
            return;
        }
        if (object == null) {
            return;
        }
        int n3 = this.getRealRowCount();
        int n4 = this.getRealColumnCount();
        boolean bl = false;
        String string = object.toString().trim();
        boolean bl2 = true;
        try {
            Double.parseDouble(string);
        }
        catch (Exception exception) {
            bl2 = false;
        }
        int n5 = 4;
        if (n2 < this.classes.length) {
            n5 = this.classes[n2];
        }
        boolean bl3 = object.equals("TRUE") || object.equals("FALSE");
        boolean bl4 = object.equals("NA") || object.equals("");
        Deducer.eval("rm(\"" + this.tempDataName + "\",envir=" + guiEnv + ");");
        if (bl4) {
            Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<- NA");
            this.setPageValue(NA_STRING, n, n2);
        } else if (n5 == 3) {
            boolean bl5 = ((REXPLogical)Deducer.eval("'" + object.toString() + "' %in% " + "levels(" + this.rDataName + "[," + (n2 + 1) + "])")).isFALSE()[0];
            if (bl5) {
                String string2 = "levels(" + this.rDataName + "[," + (n2 + 1) + "])<-c(" + "levels(" + this.rDataName + "[," + (n2 + 1) + "]),'" + object.toString() + "')";
                Deducer.eval(string2);
            }
            Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-'" + object.toString() + "'");
            this.setPageValue(object.toString(), n, n2);
        } else if (bl2 || bl3) {
            Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-" + object.toString());
            this.setPageValue(object.toString(), n, n2);
        } else {
            Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-'" + object.toString() + "'");
            this.setPageValue(object.toString(), n, n2);
            if (n5 < 3) {
                this.classes[n2] = 4;
                bl = true;
            }
        }
        Deducer.eval(guiEnv + "$" + this.tempDataName + "<-" + this.rDataName);
        this.fireTableCellUpdated(n, n2);
        if (bl) {
            this.fireTableDataChanged();
        }
        if (n + 1 > n3) {
            Deducer.eval("rownames(" + this.rDataName + ")<-make.unique(rownames(" + this.rDataName + "))");
            this.pageLocations.clear();
            this.pages.clear();
            this.pendingPages.clear();
            this.populateMetaData();
            this.fireTableRowsInserted(n3, n);
            this.fireTableRowsUpdated(n3, n);
            this.rowNamesModel.refresh();
            this.fireTableDataChanged();
        }
        if (n2 + 1 > n4) {
            this.pageLocations.clear();
            this.pages.clear();
            this.pendingPages.clear();
            this.populateMetaData();
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
        }
    }

    public Object[][] getRange(int n, int n2, int n3, int n4) {
        if (n >= this.nrow || n3 >= this.ncol) {
            return new Object[0][0];
        }
        n2 = Math.min(n2, this.nrow);
        n4 = Math.min(n4, this.ncol);
        Object[][] objectArray = new Object[n2 - n][n4 - n3];
        for (int i = n3; i < n4; ++i) {
            String[] stringArray;
            try {
                stringArray = Deducer.eval("format(" + this.rDataName + "[(" + (n + 1) + "):(" + Math.min(this.nrow, n2 + 1) + ")," + (i + 1) + "])").asStrings();
                boolean[] blArray = Deducer.eval(this.rDataName + "[(" + (n + 1) + "):(" + Math.min(this.nrow, n2 + 1) + ")," + (i + 1) + "]").isNA();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!blArray[j]) continue;
                    stringArray[j] = "NA";
                }
            }
            catch (Exception exception) {
                stringArray = new String[n2 - n];
                exception.printStackTrace();
            }
            for (int j = 0; j < n2 - n; ++j) {
                objectArray[j][i - n3] = j - n < stringArray.length ? stringArray[j] : null;
            }
        }
        return objectArray;
    }

    public void setRange(Object[][] objectArray, int n, int n2) {
        String string = "temporary" + new Random().nextDouble();
        REXP rEXP = Deducer.eval(guiEnv);
        if (objectArray.length == 0) {
            return;
        }
        int n3 = objectArray.length;
        int n4 = objectArray[0].length;
        for (int i = 0; i < n4; ++i) {
            Object object;
            int n5;
            int n6 = 1;
            for (n5 = 0; n5 < n3; ++n5) {
                try {
                    if (objectArray[n5].length <= i || objectArray[n5][i] == null) continue;
                    Double.parseDouble(objectArray[n5][i].toString());
                    continue;
                }
                catch (Exception exception) {
                    if (objectArray[n5][i].toString().equals("NA")) continue;
                    n6 = 0;
                    break;
                }
            }
            n5 = n6;
            if (n6 != 0) {
                for (int j = 0; j < n3; ++j) {
                    try {
                        if (objectArray[j].length <= i || objectArray[j][i] == null) continue;
                        Integer.parseInt(objectArray[j][i].toString());
                        continue;
                    }
                    catch (Exception exception) {
                        if (objectArray[j][i].toString().equals("NA")) continue;
                        n5 = 0;
                        break;
                    }
                }
            }
            if (this.classes[n2 + i] == 3) {
                object = new HashSet();
                for (int j = 0; j < n3; ++j) {
                    if (objectArray[j].length <= i || objectArray[j][i] == null || objectArray[j][i].toString().equals("NA")) continue;
                    object.add(objectArray[j][i].toString());
                    if (object.size() <= 10000) continue;
                    object = new HashSet();
                    break;
                }
                Object[] objectArray2 = object.toArray();
                for (int j = 0; j < objectArray2.length; ++j) {
                    String string2 = (String)objectArray2[j];
                    boolean bl = ((REXPLogical)Deducer.eval("'" + string2.toString() + "' %in% " + "levels(" + this.rDataName + "[," + (n2 + i + 1) + "])")).isFALSE()[0];
                    if (!bl) continue;
                    String string3 = "levels(" + this.rDataName + "[," + (n2 + i + 1) + "])<-c(" + "levels(" + this.rDataName + "[," + (n2 + i + 1) + "]),'" + string2.toString() + "')";
                    Deducer.eval(string3);
                }
            }
            if (n5 != 0) {
                object = new int[n3];
                for (int j = 0; j < n3; ++j) {
                    object[j] = objectArray[j].length > i && objectArray[j][i] != null && !objectArray[j][i].toString().equals("NA") ? (Object)Integer.parseInt(objectArray[j][i].toString()) : (String)Integer.MIN_VALUE;
                }
                try {
                    Deducer.getREngine().assign(string, new REXPInteger((int[])object), rEXP);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (n6 != 0) {
                object = new double[n3];
                for (int j = 0; j < n3; ++j) {
                    object[j] = objectArray[j].length > i && objectArray[j][i] != null && !objectArray[j][i].toString().equals("NA") ? (Object)Double.parseDouble(objectArray[j][i].toString()) : (String)REXPDouble.NA;
                }
                try {
                    Deducer.getREngine().assign(string, new REXPDouble((double[])object), rEXP);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                object = new String[n3];
                for (int j = 0; j < n3; ++j) {
                    object[j] = objectArray[j].length > i && objectArray[j][i] != null && !objectArray[j][i].toString().equals("NA") ? objectArray[j][i].toString() : null;
                }
                try {
                    Deducer.getREngine().assign(string, new REXPString((String[])object), rEXP);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            Deducer.eval(this.rDataName + "[(" + (n + 1) + "):(" + (n + n3) + ")," + (n2 + i + 1) + "] <- " + guiEnv + "$" + string);
        }
        Deducer.eval("rm(\"" + string + "\",envir=" + guiEnv + ");");
        this.refresh();
    }

    public void eraseRange(int n, int n2, int n3, int n4) {
        if (n >= this.nrow || n3 >= this.ncol) {
            return;
        }
        n2 = Math.min(n2, this.nrow);
        n4 = Math.min(n4, this.ncol);
        Deducer.eval("rm(\"" + this.tempDataName + "\",envir=" + guiEnv + ");");
        Deducer.eval(this.rDataName + "[(" + (n + 1) + "):(" + n2 + ")," + (n3 + 1) + ":" + n4 + "] <- NA");
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                this.setPageValue(NA_STRING, i, j);
                this.fireTableCellUpdated(i, j);
            }
        }
        Deducer.eval(guiEnv + "$" + this.tempDataName + "<-" + this.rDataName);
    }

    public boolean refresh() {
        REXP rEXP;
        boolean bl = false;
        REXP rEXP2 = Deducer.eval("!inherits(try(eval(parse(text=\"" + Deducer.addSlashes(this.rDataName) + "\")),silent=TRUE),'try-error')");
        if (rEXP2 != null && ((REXPLogical)rEXP2).isTRUE()[0] && (rEXP = Deducer.eval("identical(" + this.rDataName + "," + guiEnv + "$" + this.tempDataName + ")")) != null && ((REXPLogical)rEXP).isFALSE()[0]) {
            REXP rEXP3 = Deducer.eval("all(dim(" + this.rDataName + ")==dim(" + guiEnv + "$" + this.tempDataName + ")) && " + "identical(colnames(" + this.rDataName + "),colnames(" + guiEnv + "$" + this.tempDataName + "))");
            Deducer.eval(guiEnv + "$" + this.tempDataName + "<-" + this.rDataName);
            this.pageLocations.clear();
            this.pages.clear();
            this.pendingPages.clear();
            this.populateMetaData();
            if (rEXP3 != null && !((REXPLogical)rEXP3).isTRUE()[0]) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RDataFrameModel.this.fireTableStructureChanged();
                    }
                });
            }
            if (rEXP3 != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RDataFrameModel.this.fireTableDataChanged();
                    }
                });
            }
            bl = true;
        }
        return bl;
    }

    public String getColumnName(int n) {
        if (n < this.getRealColumnCount()) {
            REXP rEXP = Deducer.eval("colnames(" + this.rDataName + ")[" + (n + 1) + "]");
            if (rEXP != null && rEXP.isString()) {
                try {
                    return rEXP.asString();
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    return "?";
                }
            }
            return "?";
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 <= this.getRealColumnCount();
    }

    public void removeCachedData() {
        boolean bl = ((REXPLogical)Deducer.eval("'" + guiEnv + "' %in% .getOtherObjects()")).isTRUE()[0];
        if (!bl) {
            Deducer.eval(guiEnv + "<-new.env(parent=emptyenv())");
        }
        boolean bl2 = false;
        REXP rEXP = Deducer.eval("exists('" + this.tempDataName + "',where=" + guiEnv + ",inherits=FALSE)");
        if (rEXP instanceof REXPLogical) {
            bl2 = ((REXPLogical)rEXP).isTRUE()[0];
        }
        if (bl2) {
            Deducer.eval("rm(" + this.tempDataName + ",envir=" + guiEnv + ")");
        }
    }

    protected void finalize() throws Throwable {
        this.removeCachedData();
        super.finalize();
    }

    public RowNamesListModel getRowNamesModel() {
        return this.rowNamesModel;
    }

    public void setRowNamesModel(RowNamesModel rowNamesModel) {
        this.rowNamesModel = rowNamesModel;
    }

    public class RCellRenderer
    extends ExCellRenderer {
        public final Font naFont = new Font("Dialog", 0, 6);

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n < RDataFrameModel.this.getRealRowCount() || n2 < RDataFrameModel.this.getRealColumnCount()) {
                if (object.toString().equals(NA_STRING)) {
                    this.setHorizontalAlignment(4);
                    this.setVerticalAlignment(3);
                    this.setFont(this.naFont);
                    this.setText("NA");
                } else if (n2 < RDataFrameModel.this.classes.length && RDataFrameModel.this.classes[n2] < 3) {
                    this.setHorizontalAlignment(4);
                    this.setVerticalAlignment(0);
                } else {
                    this.setHorizontalAlignment(2);
                    this.setVerticalAlignment(0);
                }
            }
            return this;
        }
    }

    class RowNamesModel
    extends RowNamesListModel {
        private String[] rowNames = null;
        private int maxChar = -1;

        RowNamesModel() {
        }

        public int getSize() {
            return RDataFrameModel.this.getRowCount();
        }

        public Object getElementAt(int n) {
            if (this.rowNames == null) {
                this.refresh();
            }
            if (n < RDataFrameModel.this.getRealRowCount()) {
                if (this.rowNames.length > n) {
                    return this.rowNames[n];
                }
                return "?";
            }
            return new Integer(n + 1).toString();
        }

        public void initHeaders(int n) {
        }

        public int getMaxNumChar() {
            if (this.maxChar < 0) {
                this.refresh();
            }
            return this.maxChar;
        }

        public void refresh() {
            if (RDataFrameModel.this.rDataName == null) {
                this.rowNames = new String[0];
                super.refresh();
                return;
            }
            REXP rEXP = Deducer.eval("!inherits(try(eval(parse(text=\"" + Deducer.addSlashes(RDataFrameModel.this.rDataName) + "\")),silent=TRUE),'try-error')");
            if (rEXP == null || !((REXPLogical)rEXP).isTRUE()[0]) {
                this.rowNames = new String[0];
                super.refresh();
                return;
            }
            try {
                this.rowNames = Deducer.eval("rownames(" + RDataFrameModel.this.rDataName + ")").asStrings();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                this.rowNames = new String[0];
            }
            int n = 0;
            for (int i = 0; i < this.rowNames.length; ++i) {
                n = Math.max(n, this.rowNames[i].length());
            }
            this.maxChar = n;
            super.refresh();
        }

        public void setElementAt(int n, Object object) {
            if (n >= RDataFrameModel.this.getRealRowCount()) {
                return;
            }
            String string = null;
            boolean bl = false;
            boolean bl2 = false;
            if (object == null) {
                return;
            }
            string = object.toString().trim();
            bl = true;
            try {
                Double.parseDouble(string);
            }
            catch (Exception exception) {
                bl = false;
            }
            bl2 = true;
            try {
                Integer.parseInt(string);
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (bl2 || bl) {
                Deducer.eval("rownames(" + RDataFrameModel.this.rDataName + ")[" + (n + 1) + "] <- " + string);
            } else {
                Deducer.eval("rownames(" + RDataFrameModel.this.rDataName + ")[" + (n + 1) + "] <- '" + string + "'");
            }
            this.refresh();
        }
    }
}

