% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimony.R
\name{parsimony}
\alias{parsimony}
\title{Parsimony of a decomposition}
\usage{
parsimony(
  emd = NULL,
  xy = NULL,
  m = NULL,
  mode = NULL,
  repl = 1,
  bulk = TRUE,
  correct = NA
)
}
\arguments{
\item{emd}{an emd object}

\item{xy}{the signal}

\item{m}{a matrix with columns of same length that xy, made of the
decomposition of the signal}

\item{mode}{the mode sequence index to give to each replicated IMFs}

\item{repl}{the replication of decompositions in m}

\item{bulk}{whether to have a bulk value each decomposition replication, or
for each dt of each replication}

\item{correct}{the modes to remove from the original signal and decomposition
for a significative parsimony calculation. If NA,
it removes the last mode, considered as the residue. Can be a vector of
several integers, standing for the columns of m. If NULL, no mode is removed}
}
\value{
a matrix with each column being a replication, or a list of bulk
values for each replication
}
\description{
The function additions the absolute values of each component of
a decomposition by depth/time, and computes the ratio of that with the
absolute values of the signal. This is done either by depth/time or on the
time/depth-cumulated signal (i.e. the bulk signal).

This is a proxy for parsimony: it is the factor of amplitude added by the
decomposition. A perfect decomposition, that does not 'invent' wiggles,
should approach 1, but will logically always be higher. However it is
influenced by the absolute value of the initial signal: if the original
signal is not centered around 0, the parsimony is not significative (it
will artificially be closer to 1). To correct for that, the residue (part of
the decomposition that is not centered around zero) has to be removed from
the original signal.
}
\examples{
set.seed(42)

n <- 500

dt <- seq_len(n)
xy <- rnorm(n, mean = 0, sd = 1) + 10

dec <- extricate(xy, dt, nimf = 7, comb = 10,
                 factor_noise = 1, speak = TRUE)
\donttest{
plot_emd(dec, dir = tempdir())}

parsimony(dec, correct = NULL)

parsimony(dec)

}
