% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode.in.R
\name{mode.in}
\alias{mode.in}
\alias{mode.out}
\alias{mode.bind}
\title{Add / Remove / Bind modes in emd objects}
\usage{
mode.in(emd, xy, mode = NA, adjust = TRUE, name = "Added")

mode.out(obj, keep = NULL, lose = NULL, adjust = F, reorder = F)

mode.bind(emd, mode = NA, xy = NULL, adjust = T, name = "bound")
}
\arguments{
\item{emd}{emd-type object}

\item{xy}{an Instrinsic Mode Function to add}

\item{mode, keep, lose}{[mode.in] the position where to add the mode /
[mode.out] the modes to keep or lose / [mode.bind] the modes to merge}

\item{adjust}{whether to adapt the initial signal of an emd object ($xy in
the emd object) when adding or removing a mode}

\item{name}{the name of the new mode}

\item{obj}{emd or pulse type object}

\item{reorder}{whether to reinitialise the index of modes when suppressing
one}
}
\description{
Add / Remove / Bind modes in emd objects
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7,
                 repl = 10, comb = 10, factor_noise = 10,
                 speak = TRUE)

opar <- par('mfrow')

par(mfrow = c(2,1))

integrity(xy, dec)

ht  <- inst.pulse(dec, plot = FALSE)

plot_hist(x = 1/ht$f, breaks = 500, id = ht$mode,
          xlog = TRUE, text = TRUE, xlab = "Period",
          main = "Initial Decomposition")

bound <- mode.bind(dec, mode = c(6,7))

ht2  <- inst.pulse(bound, plot = FALSE)

plot_hist(x = 1/ht2$f, breaks = 500, id = ht2$mode,
          xlog = TRUE, text = TRUE, xlab = "Period",
          main = "Binding of modes 6 and 7")

par(mfrow = opar)

\donttest{
plot_emd(bound, dir = tempdir(), adapt.axis = TRUE)}

}
