/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import net.starschema.clouddb.jdbc.BQConnection;
import net.starschema.clouddb.jdbc.Logger;

public class BQDriver
implements Driver {
    static Logger logg = Logger.getLogger(BQDriver.class.getName());
    private static final String URL_PREFIX = "jdbc:BQDriver:";
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 3;

    public static int getMajorVersionAsStatic() {
        return 1;
    }

    public static int getMinorVersionAsStatic() {
        return 3;
    }

    public static String getURLPrefix() {
        return URL_PREFIX;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties loginProp) throws SQLException {
        BQConnection localConInstance = null;
        logg.debug("Creating Connection With url: " + url);
        if (this.acceptsURL(url)) {
            localConInstance = new BQConnection(url, loginProp);
        }
        return localConInstance;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties loginProps) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not implemented.");
    }

    static {
        try {
            BQDriver driverInst = new BQDriver();
            DriverManager.registerDriver(driverInst);
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(System.getProperty("user.home") + File.separator + ".bqjdbc" + File.separator + "log4j.properties"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logg = Logger.getLogger(driverInst.getClass());
            logg.debug("Registered the driver");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

