% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbFetch,DatabaseConnectorJdbcResult-method}
\alias{dbFetch,DatabaseConnectorJdbcResult-method}
\title{Fetch records from a previously executed query}
\usage{
\S4method{dbFetch}{DatabaseConnectorJdbcResult}(res, n = -1, ...)
}
\arguments{
\item{res}{An object inheriting from \link[DBI:DBIResult-class]{DBIResult}, created by
\code{\link[DBI:dbSendQuery]{dbSendQuery()}}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbFetch()} always returns a \link{data.frame} with
as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
Passing \code{n = NA} is supported and returns an arbitrary number of rows (at least one)
as specified by the driver, but at most the remaining rows in the result set.
}
\description{
Fetch the next \code{n} elements (rows) from the result set and return them
as a data.frame.

}
\details{
\code{fetch()} is provided for compatibility with older DBI clients - for all
new code you are strongly encouraged to use \code{dbFetch()}. The default
implementation for \code{dbFetch()} calls \code{fetch()} so that it is compatible with
existing code. Modern backends should implement for \code{dbFetch()} only.
}
\seealso{
Close the result set with \code{\link[DBI:dbClearResult]{dbClearResult()}} as soon as you
finish retrieving the records you want.

Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()}

Other data retrieval generics: 
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbFetchArrow}()},
\code{\link[DBI]{dbFetchArrowChunk}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbGetQueryArrow}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendQueryArrow}()}
}
