% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_correlation.r
\name{plot_correlation}
\alias{plot_correlation}
\alias{CorrelationDiscrete}
\alias{CorrelationContinuous}
\title{Create correlation heatmap for discrete features}
\usage{
plot_correlation(data, type = c("all", "discrete", "continuous"),
  maxcat = 20, title = NULL, ...)
}
\arguments{
\item{data}{input data to be plotted, in either \link{data.frame} or \link{data.table} format.}

\item{type}{column type to be included in correlation calculation. "all" for all columns, "discrete" for discrete features, "continuous" for continuous features.}

\item{maxcat}{maximum categories allowed for each discrete feature. The default is 20.}

\item{title}{plot title}

\item{\dots}{other arguments to be passed to \link{cor}.}
}
\description{
This function creates a correlation heatmap for all discrete categories.
}
\details{
For discrete features, the function first dummifies all categories, then calculates the correlation matrix (see \link{cor}) and plots it.
}
\examples{
# load diamonds dataset from ggplot2
data("diamonds", package = "ggplot2")

# Plot correlation heatmap with all columns
plot_correlation(diamonds)
# Plot correlation heatmap with discrete features only
plot_correlation(diamonds, type = "d")
# Plot correlation heatmap with continuous features only
plot_correlation(diamonds, type = "c")
}
\keyword{plot_correlation}
