% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetNaTo.r
\name{SetNaTo}
\alias{SetNaTo}
\title{Set missing numerical values to an indicated value}
\usage{
SetNaTo(data, value)
}
\arguments{
\item{data}{input data, in \link{data.table} format only.}

\item{value}{the value to be set to.}
}
\description{
Quickly set all missing numerical values to an indicated value.
}
\details{
\bold{This function will only work with \link{data.table} object as input.} Consider setting your input to \link{data.table} first then assign the original class back after applying the function.
}
\examples{
# load packages
library(data.table)

# generate missing values in iris data
dt <- data.table(iris)
for (j in 1:4) set(dt, i = sample.int(150, j * 30), j, value = NA_integer_)

# set all missing values to 0
SetNaTo(dt, 0)
}
\keyword{setnato}

