% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrelationDiscrete.r
\name{CorrelationDiscrete}
\alias{CorrelationDiscrete}
\title{Create correlation heatmap for discrete features}
\usage{
CorrelationDiscrete(data, maxcat = 20, ...)
}
\arguments{
\item{data}{input data to be plotted, in either \link{data.frame} or \link{data.table} format.}

\item{maxcat}{maximum categories allowed for each feature. The default is 20.}

\item{\dots}{other arguments to be passed to \link{cor}.}
}
\description{
This function creates a correlation heatmap for all discrete categories.
}
\details{
The function first transposes all discrete categories into columns with binary outcomes, then calculates the correlation matrix (see \link{cor}) and plots it.
}
\examples{
# correlation of discrete categories from diamonds dataset
library(ggplot2)
data(diamonds)
CorrelationDiscrete(diamonds)
}
\keyword{correlationdiscrete}

