% Generated by roxygen2 (4.0.0): do not edit by hand
\name{SpreadDummy}
\alias{SpreadDummy}
\title{Spread a dummy variable (1's and 0') over a specified time period and for specified groups}
\usage{
SpreadDummy(data, Var, GroupVar = NULL, NewVar = NULL, spreadBy = -2,
  reminder = TRUE)
}
\arguments{
\item{data}{a data frame object.}

\item{Var}{a character string naming the numeric dummy variable with values 0 and 1 that you would like to spread. Can be either spread as a lag or lead.}

\item{GroupVar}{a character string naming the variable grouping the units within which \code{Var} will be spread If \code{GroupVar = NULL} then the whole variable is spread up or down. This is similar to \code{\link{shift}}, though \code{shift} slides the data and returns it to a new vector rather than the original data frame.}

\item{NewVar}{a character string specifying the name for the new variable to place the spread dummy data in.}

\item{spreadBy}{numeric value specifying how many rows (time units) to spread the data over. Negative values spread the data down--lag the data. Positive values spread the data up--lead the data.}

\item{reminder}{logical. Whether or not to remind you to order your data by the \code{GroupVar} and time variable before running \code{SpreadDummy}.}
}
\description{
Spread a dummy variable (1's and 0') over a specified time period and for specified groups
}
\examples{
# Create dummy data
ID <- sort(rep(seq(1:4), 5))
NotVar <- rep(1:5, 4)
Dummy <-  sample(c(0, 1), size = 20, replace = TRUE)
Data <- data.frame(ID, NotVar, Dummy)

# Spread
DataSpread1 <- SpreadDummy(data = Data, Var = 'Dummy',
                           spreadBy = 2, reminder = FALSE)

DataSpread2 <- SpreadDummy(data = Data, Var = 'Dummy', GroupVar = 'ID',
                           spreadBy = -2)
}
\seealso{
\code{\link{slide}}
}

