% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphDWB.R
\name{graphDWB}
\alias{graphDWB}
\title{Graph for DWB model results}
\usage{
graphDWB(var, tp, main, ...)
}
\arguments{
\item{var}{It is a list that contains a time series of type \code{\link{ts}} which you want to graph. \cr
For (\emph{tp = 2}), it is recommended to list the simulated runoff series first, followed by the observed.\cr
For (\emph{tp = 3}), it must first contain the observed precipitation series, 
followed by the simulated runoff series and finally the observed runoff. \cr
For (\emph{tp = 4}), it must first contain the observed precipitation series, 
followed by the evapotranspiration series and finally the runoff time series. \cr}

\item{tp}{Variable which is defined to choose the type of graph.}

\item{main}{Main title for the graph.}

\item{...}{Other parameters of the \pkg{dygraphs} package.}
}
\value{
Prints a dynamic graph according to the requirements.
}
\description{
This function dynamically graphs the inputs and results of the DWBmodelUN.
}
\details{
It has three types of graphs: \cr
\itemize{
  \item (\emph{tp = 1}): Plots any variable in a continuous format.\cr
  \item (\emph{tp = 2}): Compares the runoff result of the model, with the observations.\cr
  \item (\emph{tp = 3}): It allows to show a comparison between the observed and simulated runoff, as well as, with a dataset of precipitation.\cr
  \item (\emph{tp = 4}): It presents a comparison between a set of precipitation, actual or potential evapotranspiration and runoff.
  }
}
\examples{
# Example 1
data(P_sogamoso)
P.est <- ts(c(t(P_sogamoso[1, -2:-1])), star = c(2001, 1), frequency = 12)
var <- list("Precipitation" = P.est)

graphDWB(var, tp = 1, main = "Precipitation Lat:7.0 Lon:-72.94")

# Example 2
data(simDWB.sogamoso, EscSogObs)
runoff.sim <- ts(simDWB.sogamoso[,25], star = c(2001, 1), frequency = 12)
runoff.obs <- ts(EscSogObs[,25] , star = c(2001, 1), frequency = 12)
var <- list("Runoff.sim" = runoff.sim, "Runoff.obs" = runoff.obs)

graphDWB(var, tp = 2, main = "Runoff at basin closure: Gauge 24067010")

# Example 3
data(P_sogamoso, simDWB.sogamoso, EscSogObs)
P.est <- ts(c(t(P_sogamoso[1, 15:110])), star = c(2002, 1), frequency = 12)
runoff.sim <- ts(simDWB.sogamoso[13:108 ,25], star = c(2002, 1), frequency = 12)
runoff.obs <- ts(EscSogObs[13:108 ,25] , star = c(2002, 1), frequency = 12)
var <- list("Precipitation" = P.est,"Runoff.sim" = runoff.sim, "Runoff.obs" = runoff.obs)

graphDWB(var, tp = 3, main = "DWB results at Sogamoso Basin closure point")

# Example 4
data(P_sogamoso, PET_sogamoso, simDWB.sogamoso)
P <- ts(c(t(P_sogamoso[1, -2:-1])), star = c(2001, 1), frequency = 12)
PET <- ts(c(t(PET_sogamoso[1, -2:-1])), star = c(2001, 1), frequency = 12)
runoff.sim <- ts(simDWB.sogamoso[ ,25], star = c(2001, 1), frequency = 12)
var <- list("P" = P,"PET" = PET, "Runoff.sim" = runoff.sim)

graphDWB(var, tp = 4, main = "General Comparison Sogamoso Basin")

}
\author{
Carolina Vega Viviescas <cvegav@unal.edu.co> \cr
Pedro Felipe Arboleda Obando <pfarboledao@unal.edu.co> \cr
David Zamora <dazamoraa@unal.edu.co> \cr
Nicolas Duque Gardeazabal <nduqueg@unal.edu.co> \cr

Water Resources Engineering Research Group - GIREH
Universidad Nacional de Colombia - sede Bogota
}
