
###################################################################################
#'  Doubly robust difference-in-differences estimators
#'
#' The \code{DRDID} package implements different estimators for the average treatment effect on
#' the treated in difference-in-differences (DiD) setups where the parallel trends assumption
#' holds after you condition on a vector of pre-treatment covariates. The main estimators
#' implemented here are the locally efficient, doubly-robust DiD estimators proposed by
#' Sant'Anna and Zhao (2020) <https://arxiv.org/abs/1812.01723>. A number of other DiD
#' estimators discussed in Sant'Anna and Zhao (2020) are also implemented.
#'
#'
#' @references{
#'
#' \cite{Sant'Anna, Pedro H. C. and Zhao, Jun. (2020),
#' "Doubly Robust Difference-in-Differences Estimators." Journal of Econometrics, Vol. 219 (1), pp. 101-122,
#' \doi{10.1016/j.jeconom.2020.06.003}}
#' }
#' @docType package
#' @name DRDID-package
NULL
