% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.DOVE.R
\name{print}
\alias{print}
\alias{print.DOVE}
\title{Print the Primary Results of a dove() or dove2() Analysis}
\usage{
\method{print}{DOVE}(x, ...)
}
\arguments{
\item{x}{An DOVE object. The value object returned by a call to dove() or
dove2()}

\item{...}{ignored}
}
\value{
No return value, called to display key results.
}
\description{
Print the primary results of a dove() or dove2() analysis.
}
\examples{
\dontshow{
  RcppArmadillo::armadillo_throttle_cores(2)
}
data(doveData)

set.seed(1234)

smp <- sample(1:nrow(x = doveData), 500, FALSE)

# NOTE: This sample size is chosen for example only -- larger data sets
# should be used.
# See the vignette for a full dove() analysis of the doveData dataset

result <- dove(formula = Surv(event.time, event.status) ~ priority + sex + 
                         vaccine(entry.time, vaccine.status, vaccine.time),
               data = doveData[smp,])

print(x = result)

set.seed(1234)
smp <- sample(1L:nrow(x = doveData), size = 2500L)

# NOTE: This sample size is chosen for example only -- larger data sets
# should be used.
# See the vignette for a full dove2() analysis of the doveData dataset

# Fit the model with default settings
result <- dove2(formula = Surv(event.time, event.status) ~ priority + sex + 
                          vaccine(entry.time, vaccine.status, vaccine.time), 
                data = doveData[smp,])

print(x = result)

}
