% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pr_next_allele.R
\name{pr.next.allele}
\alias{pr.next.allele}
\title{Probability of seeing next allele (Dirichlet sampling)}
\usage{
pr.next.allele(i, seen, fr, theta = 0)
}
\arguments{
\item{i}{Integer (vector), allele number}

\item{seen}{Integer matrix with alleles already seen}

\item{fr}{Numeric vector with allelic proportions}

\item{theta}{Numeric giving the inbreeding coefficient}
}
\value{
numeric (vector) of probabilities
}
\description{
Probability of seeing next allele (Dirichlet sampling)
}
\details{
When a population is subdivided into subpopulations, consecutively sampled alleles are not independent draws. This function implements the Dirichlet formula which states that after sampling \eqn{n} alleles, of which \eqn{m} are of type \eqn{A_i}, the probability that the next allele is of type \eqn{A_i} equals:

\eqn{(m*\theta+(1-\theta)*p_i)/(1+(n-1)*\theta)}

The alleles already sampled are passed as the rows of the matrix \code{seen}, while the corresponding element of \code{i} specifies for which next allele the probability of sampling is computed. The length of \code{i} has to be equal to the number of rows of \code{seen}.
}
\examples{
# theta=0 means independent sampling, so after seeing
# allele 1 three times the pr. remains 1/2
pr.next.allele(1,seen=matrix(c(1,1,1),nrow=1),fr=c(1/2,1/2),theta=0)
# theta>0 slighly increases the pr. of
# seeing the same allele again
pr.next.allele(1,seen=matrix(c(1,1,1),nrow=1),fr=c(1/2,1/2),theta=0.05)

# the function also works on vectors
# after seeing 1,1,1, the pr. of 1 remains 1/2
# and the same applies to the pr. of 2 after 2,2,1
pr.next.allele(c(1,2),seen=matrix(c(1,1,1,2,2,1),nrow=2,byrow=TRUE),fr=c(1/2,1/2),theta=0)
pr.next.allele(c(1,2),seen=matrix(c(1,1,1,2,2,1),nrow=2,byrow=TRUE),fr=c(1/2,1/2),theta=0.05)
}
\seealso{
\code{\link{pr.next.alleles}}, \code{\link{rmp}}
}

