% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ibs.pairwise.db.R
\name{ibs.pairwise.db.exp}
\alias{ibs.pairwise.db.exp}
\title{Compute expected number of profiles pairs in a database that match fully and partially at each number of loci}
\usage{
ibs.pairwise.db.exp(subpops, fractions = rep(1/length(subpops),
  length(subpops)), N = 2L, ks = c("UN", "FS", "PO"), alpha.w = c(1, 0,
  0))
}
\arguments{
\item{subpops}{List with allele frequencies in each subpopulation.}

\item{fractions}{Numeric}

\item{N}{Total size of database.}

\item{ks}{IBD-probabilities for the relations that occur within subpopulations (with probabilities \code{alpha.w}) and between (with probabilities \code{alpha.b}). Passed on to \code{\link{ibdprobs}}.}

\item{alpha.w}{Numeric with same length as \code{ks}. The \code{i}'th element denotes the probability that a pair of profiles within a subpopulation is related as described by the \code{i}'th element of \code{ks}.}
}
\value{
Matrix with the expected number of full/partial matches on 0,1,2,... loci in the database.
}
\description{
For a database comparison exercise, this function computes the expected number of pairs that match fully or partially at each number of loci in a heterogeneous database.
}
\details{
When all profiles in the database are compared pairwise, one can count the number of profiles that match fully/partially for each number of loci. Such a procedure is implemented as \code{\link{ibs.pairwise.db}}. The current function computes the expected value of this matrix. The database can be heterogeneous (consisting of subpopulations with different allele frequencies) and within-subpopulation inbreeding is supported.
}
\examples{
data(freqsNLsgmplus)

# sample small db, make all pairwise comparisons and compute the expected number

N <- 1e3
db <- sample.profiles(N=N,freqs=freqsNLsgmplus)

O <- ibs.pairwise.db(db)
E <- ibs.pairwise.db.exp(subpops = list(freqsNLsgmplus),N = N)

O # observed
E # expected
}
\seealso{
\code{\link{as.dbcompare}}
}

