% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.DMRnet.R
\name{cv.DMRnet}
\alias{cv.DMRnet}
\title{cross-validation for DMRnet}
\usage{
cv.DMRnet(X, y, family = "gaussian", clust.method = "complete", o = 5,
  nlambda = 20, lam = 10^(-7), interc = TRUE, nfolds = 10,
  maxp = ifelse(family == "gaussian", ceiling(length(y)/2),
  ceiling(length(y)/4)))
}
\arguments{
\item{X}{Input data frame, of dimension n x p; each row is an observation vector. Columns can be numerical or integer for continuous predictors or factors for categorical predictors.}

\item{y}{Response variable. Numerical for family="gaussian" or a factor with two levels for family="binomial". For family="binomial" the last level in alphabetical order is the target class.}

\item{family}{Response type; one of: "gaussian", "binomial".}

\item{clust.method}{Clustering method used for partitioning levels of factors; see function \href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/hclust.html}{hclust} in package \pkg{stats} for details.}

\item{o}{Parameter of the group lasso screening step, described in \code{\link{DMRnet}}.}

\item{nlambda}{Parameter of the group lasso screening step, described in \code{\link{DMRnet}}.}

\item{lam}{Value of parameter lambda controling the amount of penalization in rigde regression. Used only for logistic regression in order to allow for parameter estimation in linearly separable setups. Used only for numerical reasons.}

\item{interc}{Should intercept(s) be fitted (default=TRUE) or set to zero (FALSE). If in X there are any categorical variables, interc=TRUE.}

\item{nfolds}{Number of folds in cross-validation.}

\item{maxp}{Maximal number of parameters of the model, smaller values result in quicker computation.}
}
\value{
An object with S3 class "cv.DMR" is  returned,  which  is  a  list  with  the  ingredients  of  the  cross-validation fit.
\describe{
  \item{df.min}{df (number of parameters) for the model with minimal cross-validated error.}
  \item{dmr.fit}{Fitted DMR object for the full data.}
  \item{cvm}{The mean cross-validated error for the entire sequence of models.}
  \item{foldid}{The fold assignments used.}
}
}
\description{
Does k-fold cross-validation for DMR and returns a value for df.
}
\details{
cv.DMRnet algorithm does k-fold cross-validation for DMRnet. The df for the minimal estimated prediction error is returned.
}
\examples{
## cv.DMRnet for linear regression
set.seed(13)
data(miete)
ytr <- miete$rent[1:1500]
Xtr <- miete$area[1:1500]
Xte <- miete$area[1501:2053]
cv <- cv.DMRnet(Xtr, ytr)
print(cv)
plot(cv)
coef(cv)
ypr <- predict(cv, newx = Xte)

}
\seealso{
\code{\link{plot.cv.DMR}} for plotting, \code{\link{coef.cv.DMR}} for extracting coefficients and \code{\link{predict.cv.DMR}} for prediction.
}

