\name{reformData}
\alias{reformData}

\title{
	Reform M-values into a two-column matrix.
}
\description{
	Reform M-values into a matrix with two columns representing
	matched control and case groups. It concatenate M-values 
	pair-by-pair based on the design matrix.
}
\usage{
reformData(mv, pd=NULL)
}

\arguments{
  \item{mv}{The input M-values matrix, NA is not allowed.
}
  \item{pd}{A design matrix, which can be generated by 'stats::model.matrix'.
  If the M-values are totally paired or single paired, just leave it to be NULL.
}
}

\value{
	A matrix with two columns representing
	matched control and case groups. If a sample has no paired sample
	in another group (say group B), then the values in group B 
	will be represented by NA.
}

\author{
	Linghao SHEN <sl013@ie.cuhk.edu.hk>
}

\examples{

	# Assume the values come from Tumor is 10 larger than those from Normal.
	
	# The case with totally paired data 
	mv1 <- matrix(1:20,5)
	reformData(mv1)
	
	# The case with One more sample from Tumour group
	# The second Tumour sample is the extra one
	mv2 <- matrix(1:25,5)
	mv2[,2] <- mv2[,2] + 5 
	patient <- factor(c(1,3,1:3))
	type = c(rep("Normal",2),rep("Tumour",3))
	pd <- model.matrix(~patient + type + 0)
	reformData(mv2, pd)
}

