% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Input.R
\name{MRreal}
\alias{MRreal}
\alias{MRnoreal}
\title{Spatial closure and allocation management procedures}
\usage{
MRreal(x, Data, reps, plot = FALSE)

MRnoreal(x, Data, reps, plot = FALSE)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the Spatial slot(s) populated
}
\description{
Management procedures that close Area 1 to fishing and reallocate
fishing effort spatially.
}
\section{Functions}{
\itemize{
\item \code{MRreal}: A spatial control that prevents fishing in area 1 and reallocates this
fishing effort to area 2 (or over other areas).

\item \code{MRnoreal}: A spatial control that prevents fishing in area 1
and does not reallocate this fishing effort to area 2.
}}

\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{MRreal}:


\code{MRnoreal}:
}

\section{Rendered Equations}{

See \href{https://blue-matter.github.io/DLMtool/reference/MRreal.html}{Online Documentation} for correctly rendered equations


}

\examples{
MRreal(1, MSEtool::Atlantic_mackerel, plot=TRUE)
MRnoreal(1, MSEtool::Atlantic_mackerel, plot=TRUE)
}
\author{
T. Carruthers
}
