% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LSRA_MCMC_sim}
\alias{LSRA_MCMC_sim}
\title{Internal SRA MCMC CPP code}
\usage{
LSRA_MCMC_sim(nits, pars, JumpCV, adapt, parLB, parUB, R0ind, inflind,
  slpind, RDind, nyears, maxage, M, Mat_age, Wt_age, Chist_a, Umax, h, CAA,
  CAAadj, sigmaR)
}
\arguments{
\item{nits}{number of iterations}

\item{pars}{vector of parameters}

\item{JumpCV}{jump cv vector}

\item{adapt}{adapt vector}

\item{parLB}{lower bounds}

\item{parUB}{upper bounds}

\item{R0ind}{index for R0}

\item{inflind}{index for inflection}

\item{slpind}{index for slope}

\item{RDind}{index for recruitment deviations}

\item{nyears}{number of projection years}

\item{maxage}{maximum age}

\item{M}{Natural mortality}

\item{Mat_age}{A vector of maturity at age}

\item{Wt_age}{A vector of weight at age}

\item{Chist_a}{A vector of historical catch observations (nyears long) going back to unfished conditions}

\item{Umax}{A numeric value representing the maximum harvest rate for any age class (rejection of sims where this occurs)}

\item{h}{steepness of SRR}

\item{CAA}{A matrix nyears (rows) by nages (columns) of catch at age (age 1 to maxage in length)}

\item{CAAadj}{internal parameter}

\item{sigmaR}{A numeric value representing the prior standard deviation of log space recruitment deviations}
}
\description{
Rcpp version of R code
}
\author{
A. Hordyk
}
