% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{group_prop}
\alias{group_prop}
\title{Combine variable proportions into groups}
\usage{
group_prop(data, prop, FG = NULL)
}
\arguments{
\item{data}{A data frame containing the compositional variables which need to
be grouped.}

\item{prop}{A character/numeric vector indicating the columns containing the
compositional variables in `data`.}

\item{FG}{A character vector of same length as `prop` specifying the group
each variable belongs to.}
}
\value{
A data-frame with additional columns appended to the end that contain
the grouped variable proportions.
}
\description{
Combine variable proportions into groups
}
\examples{
library(DImodels)

data(sim1)

head(group_prop(data = sim1, prop = 3:6,
                FG = c("Gr1", "Gr1", "Gr1", "Gr2")))

head(group_prop(data = sim1, prop = 3:6,
                FG = c("Group1", "Group2", "Group1", "Group3")))

## Data is returned as is, if no groups are specified in FG
head(group_prop(data = sim1, prop = 3:6))
}
