% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_connection.R
\name{db_connection}
\alias{db_connection}
\title{db_connection helper function}
\usage{
db_connection(
  db_name,
  db_type,
  headless = FALSE,
  from_env = TRUE,
  settings = NULL,
  timeout = 30,
  logfile_dir = NULL,
  lib_path = NULL
)
}
\arguments{
\item{db_name}{A character. Name of the database system.}

\item{db_type}{A character. Type of the database system. Currently
implemented systems are: 'postgres', 'oracle'.}

\item{headless}{A boolean (default: `FALSE`). Indicating, if the function is
run only in the console (`headless = TRUE`) or on a GUI frontend
(`headless = FALSE`).}

\item{from_env}{A boolean (default: `TRUE`). Should database connection
be read from the environment or from a settings file.}

\item{settings}{A list. Required if `from_env = TRUE`. A list containing
settings for the database connection. Required fields are `host`,
`db_name`, `port`, `user` and `password`.
Additionally for Oracle DB's: `sid` (instead of `db_name`).
If `settings` is set, `from_env` will be set to `FALSE` automatically.}

\item{timeout}{A timeout in sec. for the db-connection establishment.
Values below 2 seconds are not recommended.
Default is 30 seconds.}

\item{logfile_dir}{(Optional, String, default: "tempdir()")
The absolute path to folder where the logfile will be stored.}

\item{lib_path}{A character string. The path to the ojdbc*.jar file.
If you run one of the R-containers from the UK-Erlangen DIZ, there
might be a lib for oracle here: `lib_path = "/opt/libs/ojdbc8.jar"`
Example-Dockerfile:
https://github.com/joundso/docker_images/blob/241814e13d99511143d90f6e2217c32ad0477256/image_rdsc_headless_j/Dockerfile#L376}
}
\value{
If successful, the result will be the established connection.
  Otherwise the result will be null.
}
\description{
Internal function to test and get the database connection of
  the target data system.
}
\examples{
\dontrun{
db_con <- DIZutils::db_connection(
  db_name = "i2b2",
  db_type = "postgres",
  headless = TRUE,
  logfile_dir = tempdir()
)}

}
\seealso{
{
\code{\link[DBI]{dbConnect}}, \code{\link[RPostgres]{RPostgres}}
}
}
