% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_POSIXct.R
\name{format_posixct}
\alias{format_posixct}
\title{Formats a given POSIXct timestamp without the need of manually
  specifing format parameters.}
\usage{
format_posixct(x, lang = "en", date = TRUE, time = TRUE)
}
\arguments{
\item{x}{The POSIXct timestamp or a string to be automatically
converted to a POSIXct timestamp.}

\item{lang}{(Optional, String, Default = "en") The language of the result.
Currently implemented: "en"/"de". If you supply another not yet
implemented language here, "en" will be chosen automatically.}

\item{date}{(Optional, Boolean, Default = TRUE) Should the date be part
of the result string?}

\item{time}{(Optional, Boolean, Default = TRUE) Should the time be part
of the result string?}
}
\value{
(String) The formatted timestamp as a string.
}
\description{
See title.
}
\examples{
\dontrun{
format_POSIXct(x = "2021-12-31 12:34")
## Result: "2021-12-31, 12:34:00"
format_POSIXct(x = "2021-12-31 12:34", lang = "de")
## Result: "31.12.2021, 12:34:00"
)}

}
