% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.DIFtree.R
\name{summary.DIFtree}
\alias{print.summary.DIFtree}
\alias{summary.DIFtree}
\title{Summary for fitted Item focussed Trees}
\usage{
\method{summary}{DIFtree}(object, ...)

\method{print}{summary.DIFtree}(x, ...)
}
\arguments{
\item{object}{Object of class \code{\link[DIFtree]{DIFtree}}}

\item{...}{Further arguments passed to or from other methods}

\item{x}{Object of class \code{\link[DIFtree]{summary.DIFtree}}}
}
\value{
Object of class \code{"summary.DIFtree"}. 
An object of class \code{"summary.DIFtree"} is a list containing the following components:

\item{stats}{Useful overview of detected DIF items, responsible variables and executed splits}
\item{nosplits}{Total number of executed splits during the estimation procedure}
}
\description{
The function takes an object of class \code{"DIFtree"} and returns an useful summary 
with an overiew of all executed splits during the estimation procedure.
}
\examples{
data(data_sim)
 
Y <- data_sim[,1]
X <- data_sim[,-1]
 
\dontrun{
 
mod <- DIFtree(Y=Y,X=X,model="Logistic",type="udif",alpha=0.05,nperm=1000,trace=TRUE)
 
summary(mod)
}

}
\author{
Moritz Berger <moritz.berger@stat.uni-muenchen.de> \cr \url{http://www.statistik.lmu.de/~mberger/}
}
\references{
Berger, Moritz and Tutz, Gerhard (2015): Detection of Uniform and Non-Uniform Differential Item Functioning 
by Item Focussed Trees, Cornell University Library, arXiv:1511.07178

Tutz, Gerhard and Berger, Moritz (2015): Item Focused Trees for the Identification of Items
in Differential Item Functioning, Psychometrika, published online, DOI: 10.1007/s11336-015-9488-3
}
\seealso{
\code{\link[DIFtree]{DIFtree}}, \code{\link[DIFtree]{plot.DIFtree}}, \code{\link[DIFtree]{predict.DIFtree}}
}

