% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVals.R
\name{plotVals}
\alias{plotVals}
\title{Creates a dotplot of the overall values for an individual gene in multiple conditions.}
\usage{
plotVals(inputMat, design, compare, gene, log = FALSE, ylab = NULL,
  xlab = NULL, add_summary_bar = TRUE, summary_bar = "mean",
  summary_width = 0.75, dotplot_width = 0.5, dotplot_size = NULL,
  dotplot_binwidth = NULL)
}
\arguments{
\item{inputMat}{The matrix (or data.frame) of values (e.g., gene expression values from an RNA-seq or microarray study) that you are interested in analyzing. The rownames of this matrix should correspond to the identifiers whose values you are interested in analyzing, while the columns should correspond to the rows of the design matrix and should be separable into your groups.}

\item{design}{A standard model.matrix created design matrix. Rows correspond to samples and colnames refer to the names of the conditions that you are interested in analyzing. Only 0's or 1's are allowed in the design matrix. Please see vignettes for more information.}

\item{compare}{Vector of two character strings, each corresponding to one group name in the design matrix, that should be compared.}

\item{gene}{The gene symbol (row identifier).}

\item{log}{Logical, indicating whether the data should be log2-transformed prior to plotting (after adding a small constant of 0.5 to avoid problems with the log transform and stabilize the variance with respect to the mean).}

\item{ylab}{Override the y-axis label to one of your choice.}

\item{xlab}{Override the x-axis label to one of your choice.}

\item{add_summary_bar}{Logical indicating whether to include a summary bar for each group.}

\item{summary_bar}{If summary bar included, type of bar to use to calculate. Options = "mean", "median"}

\item{summary_width}{Horizontal width of summary crossbar included.}

\item{dotplot_width}{The width of the dots in the dotplot. See ?geom_dotplot for more information.}

\item{dotplot_size}{The diameter of the dots in the dotplot. Affects the chart relative to the dotplot binwidth. If NULL, will be calculated automatically.}

\item{dotplot_binwidth}{The binwidth size for the dots in the dotplot. If NULL, will be calculated automatically.}
}
\value{
A ggplot2 object that can be plotted, further modified, and/or saved.
}
\description{
Takes the original input matrix, a design matrix, and one gene symbols (row name of the original matrix) to plot its values in the conditions specified, using a dotplot, +/- a summary bar. Will remove NAs prior to plotting.
}

