% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{transpose_gene_ids}
\alias{transpose_gene_ids}
\title{Rename gene IDs based on a 1-to-1 mapping file.}
\usage{
transpose_gene_ids(count_data, meta_file)
}
\arguments{
\item{count_data}{Count data as read using the prep_counts() function.}

\item{meta_file}{File containing 1-to-1 gene id mapping. Tab-delimited format expected.
Column 1 should be titled, "Gene stable ID" and column 2 should be titled "Gene name".}
}
\value{
This function returns a count data set with gene IDs replaced by those provided in the meta_file parameter.
}
\description{
This function accepts a 1-to-1 mapping file of gene ids and updates count data to reflect the new IDs.  The mapping file should contain
two columns "Gene stable ID" and "Gene name".  The "Gene stable id" should correspond to gene ids in your count data file, and "gene name"
will be used to replace the existing genes.  This function has can be used to translate difficult to understand gene identifiers, such as
ensembl IDs to to more human readable gene names.  A mapping file can be generated at \url{http://www.ensembl.org/biomart/martview/}.
This function should be run using count data read by prep_counts().  The returned data can then be used in prep_dds_from_data().
}
\examples{
\dontrun{

#Transpose IDs from current count data to their desired values based on the meta_file.
count_data  <- prep_counts(my_count_file)
new_count_data <- transpose_gene_ids(count_data, meta_file)

#Updated gene ID count information can be used in DE analysis.
dds <- prep_dds_from_data(new_count_data, target_data, ~ Design_Type, TRUE,
                           "Replicate", "vst")

}
}
\seealso{
\url{http://www.ensembl.org/biomart/martview/}, \code{\link{prep_counts}}, \code{\link{prep_dds_from_data}}
}
\keyword{id}
\keyword{rename}
\keyword{transpose}
